"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TemplateEdit = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../shared_imports");
var _breadcrumbs = require("../../services/breadcrumbs");
var _api = require("../../services/api");
var _routing = require("../../services/routing");
var _components = require("../../components");
var _index_templates = require("../../lib/index_templates");
var _app_context = require("../../app_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/sections/template_edit/template_edit.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TemplateEdit = ({
  match: {
    params: {
      name
    }
  },
  location,
  history
}) => {
  const decodedTemplateName = (0, _shared_imports.attemptToURIDecode)(name);
  const {
    config: {
      enableLegacyTemplates
    }
  } = (0, _app_context.useAppContext)();

  // We don't expect the `legacy` query to be used when legacy templates are disabled, however, we add the enableLegacyTemplates check as a safeguard
  const isLegacy = enableLegacyTemplates && (0, _index_templates.getIsLegacyFromQueryParams)(location);
  const [isSaving, setIsSaving] = (0, _react.useState)(false);
  const [saveError, setSaveError] = (0, _react.useState)(null);
  const {
    error,
    data: template,
    isLoading
  } = (0, _api.useLoadIndexTemplate)(decodedTemplateName, isLegacy);
  (0, _react.useEffect)(() => {
    _breadcrumbs.breadcrumbService.setBreadcrumbs(_breadcrumbs.IndexManagementBreadcrumb.templateEdit);
  }, []);
  const onSave = async updatedTemplate => {
    setIsSaving(true);
    setSaveError(null);
    const {
      error: saveErrorObject
    } = await (0, _api.updateTemplate)(updatedTemplate);
    setIsSaving(false);
    if (saveErrorObject) {
      setSaveError(saveErrorObject);
      return;
    }
    history.push((0, _routing.getTemplateDetailsLink)(decodedTemplateName, updatedTemplate._kbnMeta.isLegacy));
  };
  const clearSaveError = () => {
    setSaveError(null);
  };
  let isSystemTemplate;
  let isDeprecatedTemplate;
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_shared_imports.PageLoading, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.templateEdit.loadingIndexTemplateDescription",
      defaultMessage: "Loading template\u2026",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 9
      }
    }));
  } else if (error) {
    return /*#__PURE__*/_react.default.createElement(_shared_imports.PageError, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.templateEdit.loadingIndexTemplateErrorMessage",
        defaultMessage: "Error loading template",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 89,
          columnNumber: 11
        }
      }),
      error: error,
      "data-test-subj": "sectionError",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 7
      }
    });
  } else if (template) {
    const {
      name: templateName,
      _kbnMeta: {
        type
      }
    } = template;
    isSystemTemplate = templateName && templateName.startsWith('.');
    isDeprecatedTemplate = template === null || template === void 0 ? void 0 : template.deprecated;
    if (type === 'cloudManaged') {
      return /*#__PURE__*/_react.default.createElement(_shared_imports.PageError, {
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.idxMgmt.templateEdit.managedTemplateWarningTitle",
          defaultMessage: "Editing a managed template is not permitted",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 111,
            columnNumber: 13
          }
        }),
        error: {
          message: _i18n.i18n.translate('xpack.idxMgmt.templateEdit.managedTemplateWarningDescription', {
            defaultMessage: 'Managed templates are critical for internal operations.'
          })
        },
        "data-test-subj": "systemTemplateEditCallout",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 109,
          columnNumber: 9
        }
      });
    }
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
    restrictWidth: true,
    style: {
      width: '100%'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 5
    }
  }, isSystemTemplate && /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.templateEdit.systemTemplateWarningTitle",
      defaultMessage: "Editing a system template can break Kibana",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 15
      }
    }),
    color: "danger",
    iconType: "warning",
    "data-test-subj": "systemTemplateEditCallout",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.templateEdit.systemTemplateWarningDescription",
    defaultMessage: "System templates are critical for internal operations.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 11
    }
  })), isDeprecatedTemplate && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.templateEdit.deprecatedTemplateWarningTitle",
      defaultMessage: "This index template is deprecated",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 159,
        columnNumber: 15
      }
    }),
    iconType: "warning",
    color: "warning",
    "data-test-subj": "deprecatedIndexTemplateCallout",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.templateEdit.deprecatedTemplateWarningDescription",
    defaultMessage: "This index template is no longer supported and might be removed in a future release. Instead, use one of the other index templates available or create a new one.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_components.TemplateForm, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.editTemplate.editTemplatePageTitle",
      defaultMessage: "Edit template ''{name}''",
      values: {
        name: decodedTemplateName
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 179,
        columnNumber: 11
      }
    }),
    defaultValue: template,
    onSave: onSave,
    isSaving: isSaving,
    saveError: saveError,
    clearSaveError: clearSaveError,
    isEditing: true,
    isLegacy: isLegacy,
    history: history,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 7
    }
  }));
};
exports.TemplateEdit = TemplateEdit;