"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManageIndexButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _services = require("../../../../services");
var _notification = require("../../../../services/notification");
var _http = require("../../../../services/http");
var _index_actions_context_menu = require("../index_actions_context_menu/index_actions_context_menu");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/sections/home/index_list/details_page/manage_index_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getIndexStatusByName = (indexNames, indices) => {
  const indexStatusByName = {};
  indexNames.forEach(indexName => {
    var _indices$find;
    const {
      status
    } = (_indices$find = indices.find(index => index.name === indexName)) !== null && _indices$find !== void 0 ? _indices$find : {};
    indexStatusByName[indexName] = status;
  });
  return indexStatusByName;
};
/**
 * This component is a wrapper for the underlying "index actions context menu" that is currently used
 * in the indices list and works with redux. That is why all request helpers from the services are expecting
 * an array of indices, for example "deleteIndices(indexNames)".
 *
 */
const ManageIndexButton = ({
  index,
  reloadIndexDetails,
  navigateToIndicesList
}) => {
  const [isLoading, setIsLoading] = (0, _react.useState)(false);

  // the "index actions context menu" component is expecting an array of indices, the same as on the indices list
  const indexNames = (0, _react.useMemo)(() => [index.name], [index]);
  const reloadIndices = (0, _react.useCallback)(async () => {
    setIsLoading(true);
    await reloadIndexDetails();
    setIsLoading(false);
  }, [reloadIndexDetails]);

  // the "index actions context menu" component is expecting an array of indices, the same as on the indices list
  const indices = [index];
  const indexStatusByName = getIndexStatusByName(indexNames, indices);
  const closeIndices = (0, _react.useCallback)(async () => {
    setIsLoading(true);
    try {
      await (0, _services.closeIndices)(indexNames);
      await reloadIndices();
      setIsLoading(false);
      _notification.notificationService.showSuccessToast(_i18n.i18n.translate('xpack.idxMgmt.closeIndicesAction.indexClosedMessage', {
        defaultMessage: 'The index {indexNames} was closed.',
        values: {
          indexNames: indexNames.join(', ')
        }
      }));
    } catch (error) {
      setIsLoading(false);
      _notification.notificationService.showDangerToast(error.body.message);
    }
  }, [reloadIndices, indexNames]);
  const openIndices = (0, _react.useCallback)(async () => {
    setIsLoading(true);
    try {
      await (0, _services.openIndices)(indexNames);
      await reloadIndices();
      setIsLoading(false);
      _notification.notificationService.showSuccessToast(_i18n.i18n.translate('xpack.idxMgmt.openIndicesAction.indexOpenedMessage', {
        defaultMessage: 'The index {indexNames} was opened.',
        values: {
          indexNames: indexNames.join(', ')
        }
      }));
    } catch (error) {
      setIsLoading(false);
      _notification.notificationService.showDangerToast(error.body.message);
    }
  }, [reloadIndices, indexNames]);
  const flushIndices = (0, _react.useCallback)(async () => {
    setIsLoading(true);
    try {
      await (0, _services.flushIndices)(indexNames);
      await reloadIndices();
      setIsLoading(false);
      _notification.notificationService.showSuccessToast(_i18n.i18n.translate('xpack.idxMgmt.flushIndicesAction.indexFlushedMessage', {
        defaultMessage: 'The index {indexNames} was flushed.',
        values: {
          indexNames: indexNames.join(', ')
        }
      }));
    } catch (error) {
      setIsLoading(false);
      _notification.notificationService.showDangerToast(error.body.message);
    }
  }, [reloadIndices, indexNames]);
  const refreshIndices = (0, _react.useCallback)(async () => {
    setIsLoading(true);
    try {
      await (0, _services.refreshIndices)(indexNames);
      await reloadIndices();
      setIsLoading(false);
      _notification.notificationService.showSuccessToast(_i18n.i18n.translate('xpack.idxMgmt.refreshIndicesAction.indexRefreshedMessage', {
        defaultMessage: 'The index {indexNames} was refreshed.',
        values: {
          indexNames: indexNames.join(', ')
        }
      }));
    } catch (error) {
      setIsLoading(false);
      _notification.notificationService.showDangerToast(error.body.message);
    }
  }, [reloadIndices, indexNames]);
  const clearCacheIndices = (0, _react.useCallback)(async () => {
    setIsLoading(true);
    try {
      await (0, _services.clearCacheIndices)(indexNames);
      await reloadIndices();
      setIsLoading(false);
      _notification.notificationService.showSuccessToast(_i18n.i18n.translate('xpack.idxMgmt.clearCacheIndicesAction.indexCacheClearedMessage', {
        defaultMessage: 'The cache of the index {indexNames} was cleared.',
        values: {
          indexNames: indexNames.join(', ')
        }
      }));
    } catch (error) {
      setIsLoading(false);
      _notification.notificationService.showDangerToast(error.body.message);
    }
  }, [reloadIndices, indexNames]);
  const forcemergeIndices = (0, _react.useCallback)(async maxNumSegments => {
    setIsLoading(true);
    try {
      await (0, _services.forcemergeIndices)(indexNames, maxNumSegments);
      await reloadIndices();
      setIsLoading(false);
      _notification.notificationService.showSuccessToast(_i18n.i18n.translate('xpack.idxMgmt.forceMergeIndicesAction.indexForcemergedMessage', {
        defaultMessage: 'The index {indexNames} was force merged.',
        values: {
          indexNames: indexNames.join(', ')
        }
      }));
    } catch (error) {
      setIsLoading(false);
      _notification.notificationService.showDangerToast(error.body.message);
    }
  }, [reloadIndices, indexNames]);
  const deleteIndices = (0, _react.useCallback)(async () => {
    setIsLoading(true);
    try {
      await (0, _services.deleteIndices)(indexNames);
      setIsLoading(false);
      _notification.notificationService.showSuccessToast(_i18n.i18n.translate('xpack.idxMgmt.deleteIndicesAction.indexDeletedMessage', {
        defaultMessage: 'The index {indexNames} was deleted.',
        values: {
          indexNames: indexNames.join(', ')
        }
      }));
      navigateToIndicesList();
    } catch (error) {
      setIsLoading(false);
      _notification.notificationService.showDangerToast(error.body.message);
    }
  }, [navigateToIndicesList, indexNames]);
  const performExtensionAction = (0, _react.useCallback)(async (requestMethod, successMessage) => {
    setIsLoading(true);
    try {
      await requestMethod(indexNames, _http.httpService.httpClient);
      await reloadIndices();
      setIsLoading(false);
      _notification.notificationService.showSuccessToast(successMessage);
    } catch (error) {
      setIsLoading(false);
      _notification.notificationService.showDangerToast(error.body.message);
    }
  }, [reloadIndices, indexNames]);
  return /*#__PURE__*/_react.default.createElement(_index_actions_context_menu.IndexActionsContextMenu, {
    indexNames: indexNames,
    indices: indices,
    indexStatusByName: indexStatusByName,
    fill: false,
    isLoading: isLoading
    // index actions
    ,
    closeIndices: closeIndices,
    openIndices: openIndices,
    flushIndices: flushIndices,
    refreshIndices: refreshIndices,
    clearCacheIndices: clearCacheIndices,
    forcemergeIndices: forcemergeIndices,
    deleteIndices: deleteIndices,
    performExtensionAction: performExtensionAction,
    reloadIndices: reloadIndices,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 5
    }
  });
};
exports.ManageIndexButton = ManageIndexButton;