"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMappingsState = exports.useDispatch = exports.StateProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reducer = require("./reducer");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/mappings_editor/mappings_state_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StateContext = /*#__PURE__*/(0, _react.createContext)(undefined);
const DispatchContext = /*#__PURE__*/(0, _react.createContext)(undefined);
const StateProvider = ({
  children
}) => {
  const initialState = {
    isValid: true,
    configuration: {
      defaultValue: {},
      data: {
        internal: {},
        format: () => ({})
      },
      validate: () => Promise.resolve(true)
    },
    templates: {
      defaultValue: {},
      data: {
        internal: {},
        format: () => ({})
      },
      validate: () => Promise.resolve(true)
    },
    fields: {
      byId: {},
      rootLevelFields: [],
      aliases: {},
      maxNestedDepth: 0
    },
    documentFields: {
      status: 'idle',
      editor: 'default'
    },
    runtimeFields: {},
    runtimeFieldsList: {
      status: 'idle'
    },
    fieldsJsonEditor: {
      format: () => ({}),
      isValid: true
    },
    search: {
      term: '',
      result: []
    },
    filter: {
      filteredFields: [],
      selectedOptions: [],
      selectedDataTypes: []
    },
    inferenceToModelIdMap: {},
    mappingViewFields: {
      byId: {},
      rootLevelFields: [],
      aliases: {},
      maxNestedDepth: 0
    }
  };
  const [state, dispatch] = (0, _react.useReducer)(_reducer.reducer, initialState);
  return /*#__PURE__*/_react.default.createElement(StateContext.Provider, {
    value: state,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(DispatchContext.Provider, {
    value: dispatch,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  }, children));
};
exports.StateProvider = StateProvider;
const useMappingsState = () => {
  const ctx = (0, _react.useContext)(StateContext);
  if (ctx === undefined) {
    throw new Error('useMappingsState must be used within a <MappingsState>');
  }
  return ctx;
};
exports.useMappingsState = useMappingsState;
const useDispatch = () => {
  const ctx = (0, _react.useContext)(DispatchContext);
  if (ctx === undefined) {
    throw new Error('useDispatch must be used within a <MappingsState>');
  }
  return ctx;
};
exports.useDispatch = useDispatch;