"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataAllocation = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _lib = require("../../../../lib");
var _action_description = require("./action_description");
var _i18n_texts = require("../../../edit_policy/i18n_texts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/index_lifecycle_management/public/application/sections/policy_list/policy_flyout/components/data_allocation.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getAllocationDescription = (type, phase, allocate) => {
  if (type === 'none') {
    return _i18n.i18n.translate('xpack.indexLifecycleMgmt.policyFlyout.dataAllocationDisabledLabel', {
      defaultMessage: 'Disabled'
    });
  }
  if (type === 'node_roles') {
    const label = phase === 'warm' ? _i18n.i18n.translate('xpack.indexLifecycleMgmt.policyFlyout.dataAllocationWarmNodesLabel', {
      defaultMessage: 'Using warm nodes'
    }) : _i18n.i18n.translate('xpack.indexLifecycleMgmt.policyFlyout.dataAllocationColdNodesdLabel', {
      defaultMessage: 'Using cold nodes'
    });
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, label, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "success",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.indexLifecycleMgmt.policyFlyout.recommendedDataAllocationLabel",
      defaultMessage: "Recommended",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 11
      }
    })));
  }
  if (type === 'node_attrs') {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.indexLifecycleMgmt.policyFlyout.dataAllocationAttributtesLabel', {
      defaultMessage: 'Node attributes'
    }), ': ', /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 9
      }
    }, JSON.stringify(allocate === null || allocate === void 0 ? void 0 : allocate.require)));
  }
};
const DataAllocation = ({
  phase,
  phases
}) => {
  const phaseConfig = phases[phase];
  const allocate = phaseConfig === null || phaseConfig === void 0 ? void 0 : phaseConfig.actions.allocate;
  const migrate = phaseConfig === null || phaseConfig === void 0 ? void 0 : phaseConfig.actions.migrate;
  const allocationType = (0, _lib.determineDataTierAllocationType)({
    allocate,
    migrate
  });
  const allocationDescription = getAllocationDescription(allocationType, phase, allocate);
  return /*#__PURE__*/_react.default.createElement(_action_description.ActionDescription, {
    title: _i18n_texts.i18nTexts.editPolicy.dataAllocationLabel,
    descriptionItems: allocationDescription ? [allocationDescription] : [],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 5
    }
  });
};
exports.DataAllocation = DataAllocation;