"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ImageEmbeddable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _presentationPublishing = require("@kbn/presentation-publishing");
var _rxjs = require("rxjs");
var _actions = require("../actions");
var _imports = require("../imports");
var _kibana_services = require("../services/kibana_services");
var _validate_url = require("../utils/validate_url");
var _image_viewer = require("./image_viewer");
var _image_viewer_context = require("./image_viewer/image_viewer_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/private/image_embeddable/public/components/image_embeddable.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ImageEmbeddable = ({
  api,
  filesClient
}) => {
  var _api$dynamicActionsSt;
  const [imageConfig, dynamicActionsState] = (0, _presentationPublishing.useBatchedPublishingSubjects)(api.imageConfig$, (_api$dynamicActionsSt = api.dynamicActionsState$) !== null && _api$dynamicActionsSt !== void 0 ? _api$dynamicActionsSt : new _rxjs.BehaviorSubject(undefined));
  const [hasTriggerActions, setHasTriggerActions] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    /**
     * set the loading to `true` any time the image changes; the ImageViewer component
     * is responsible for setting loading to `false` again once the image loads
     */
    api.setDataLoading(true);
  }, [api, imageConfig]);
  (0, _react.useEffect)(() => {
    var _dynamicActionsState$;
    // set `hasTriggerActions` depending on whether or not the image has at least one drilldown
    setHasTriggerActions(((_dynamicActionsState$ = dynamicActionsState === null || dynamicActionsState === void 0 ? void 0 : dynamicActionsState.dynamicActions.events) !== null && _dynamicActionsState$ !== void 0 ? _dynamicActionsState$ : []).length > 0);
  }, [dynamicActionsState]);
  return /*#__PURE__*/_react.default.createElement(_image_viewer_context.ImageViewerContext.Provider, {
    value: {
      getImageDownloadHref: fileId => {
        return filesClient.getDownloadHref({
          id: fileId,
          fileKind: _imports.imageEmbeddableFileKind.id
        });
      },
      validateUrl: (0, _validate_url.createValidateUrl)(_kibana_services.coreServices.http.externalUrl)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_image_viewer.ImageViewer
  // TODO: Remove data-shared-item and data-rendering-count as part of https://github.com/elastic/kibana/issues/179376
  , {
    "data-shared-item": '',
    "data-rendering-count": 1,
    className: "imageEmbeddableImage",
    imageConfig: imageConfig,
    isScreenshotMode: _kibana_services.screenshotModeService === null || _kibana_services.screenshotModeService === void 0 ? void 0 : _kibana_services.screenshotModeService.isScreenshotMode(),
    onLoad: () => {
      api.setDataLoading(false);
    },
    onError: () => {
      api.setDataLoading(false);
    },
    onClick:
    // note: passing onClick enables the cursor pointer style, so we only pass it if there are compatible actions
    hasTriggerActions ? () => {
      _kibana_services.uiActionsService.executeTriggerActions(_actions.imageClickTrigger.id, {
        embeddable: api
      });
    } : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }));
};
exports.ImageEmbeddable = ImageEmbeddable;