"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UninstallButton = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _types = require("../../../../../types");
var _hooks = require("../../../../../hooks");
var _confirm_package_uninstall = require("./confirm_package_uninstall");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/integrations/sections/epm/screens/detail/settings/uninstall_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const UninstallButton = ({
  disabled = false,
  latestVersion,
  name,
  assets,
  title,
  version
}) => {
  const canRemovePackages = (0, _hooks.useAuthz)().integrations.removePackages;
  const uninstallPackage = (0, _hooks.useUninstallPackage)();
  const getPackageInstallStatus = (0, _hooks.useGetPackageInstallStatus)();
  const {
    status: installationStatus
  } = getPackageInstallStatus(name);
  const isRemoving = installationStatus === _types.InstallStatus.uninstalling;
  const [isUninstallModalVisible, setIsUninstallModalVisible] = (0, _react.useState)(false);
  const numOfAssets = Object.entries(assets).reduce((acc, [serviceName, serviceNameValue]) => acc + Object.entries(serviceNameValue || {}).reduce((acc2, [assetName, assetNameValue]) => acc2 + assetNameValue.length, 0), 0);
  const handleClickUninstall = (0, _react.useCallback)(() => {
    uninstallPackage({
      name,
      version,
      title,
      redirectToVersion: latestVersion !== null && latestVersion !== void 0 ? latestVersion : version
    });
    setIsUninstallModalVisible(false);
  }, [uninstallPackage, name, title, version, latestVersion]);
  const uninstallModal = /*#__PURE__*/_react.default.createElement(_confirm_package_uninstall.ConfirmPackageUninstall
  // this is number of which would be installed
  // deleted includes ingest-pipelines etc so could be larger
  // not sure how to do this at the moment so using same value
  , {
    numOfAssets: numOfAssets,
    packageName: title,
    onCancel: () => setIsUninstallModalVisible(false),
    onConfirm: handleClickUninstall,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 5
    }
  });
  return canRemovePackages ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "uninstallAssetsButton",
    iconType: 'trash',
    isLoading: isRemoving,
    onClick: () => setIsUninstallModalVisible(true),
    color: "danger",
    disabled: disabled || isRemoving ? true : false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }, isRemoving ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrations.uninstallPackage.uninstallingPackageButtonLabel",
    defaultMessage: "Uninstalling {title}",
    values: {
      title
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrations.uninstallPackage.uninstallPackageButtonLabel",
    defaultMessage: "Uninstall {title}",
    values: {
      title
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 11
    }
  })), isUninstallModalVisible && uninstallModal) : null;
};
exports.UninstallButton = UninstallButton;