"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SettingsPage = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18nReact = require("@kbn/i18n-react");
var _lt = _interopRequireDefault(require("semver/functions/lt"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _types = require("../../../../../types");
var _hooks = require("../../../../../hooks");
var _constants = require("../../../../../constants");
var _side_bar_column = require("../../../components/side_bar_column");
var _use_bulk_actions_context = require("../../installed_integrations/hooks/use_bulk_actions_context");
var _components = require("../components");
var _hooks2 = require("../hooks");
var _services = require("../../../../../services");
var _install_button = require("./install_button");
var _reinstall_button = require("./reinstall_button");
var _update_button = require("./update_button");
var _uninstall_button = require("./uninstall_button");
var _changelog_modal = require("./changelog_modal");
var _update_available_callout = require("./update_available_callout");
var _breaking_changes_flyout = require("./breaking_changes_flyout");
var _rollback_button = require("./rollback_button");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/integrations/sections/epm/screens/detail/settings/settings.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SettingsTitleCell = _styledComponents.default.td`
  padding-right: ${props => props.theme.eui.euiSizeXL};
  padding-bottom: ${props => props.theme.eui.euiSizeM};
`;
const NoteLabel = () => /*#__PURE__*/_react.default.createElement("strong", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 65,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.fleet.integrations.settings.packageUninstallNoteDescription.packageUninstallNoteLabel",
  defaultMessage: "Note:",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 66,
    columnNumber: 5
  }
}));
const LatestVersionLink = ({
  name,
  version
}) => {
  const {
    getHref
  } = (0, _hooks.useLink)();
  const settingsPath = getHref('integration_details_settings', {
    pkgkey: `${name}-${version}`
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: settingsPath,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrations.settings.packageLatestVersionLink",
    defaultMessage: "latest version",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }));
};
const SettingsPage = exports.SettingsPage = /*#__PURE__*/(0, _react.memo)(({
  packageInfo,
  packageMetadata,
  startServices,
  isCustomPackage
}) => {
  var _packageInfo$installa;
  const authz = (0, _hooks.useAuthz)();
  const {
    name,
    title,
    latestVersion,
    version,
    keepPoliciesUpToDate
  } = packageInfo;
  const [isUpgradingPackagePolicies, setIsUpgradingPackagePolicies] = (0, _react.useState)(false);
  const [isChangelogModalOpen, setIsChangelogModalOpen] = (0, _react.useState)(false);
  const [isBreakingChangesUnderstood, setIsBreakingChangesUnderstood] = (0, _react.useState)(false);
  const [isBreakingChangesFlyoutOpen, setIsBreakingChangesFlyoutOpen] = (0, _react.useState)(false);
  const {
    enablePackageRollback
  } = _services.ExperimentalFeaturesService.get();
  const toggleChangelogModal = (0, _react.useCallback)(() => {
    setIsChangelogModalOpen(!isChangelogModalOpen);
  }, [isChangelogModalOpen]);
  const getPackageInstallStatus = (0, _hooks.useGetPackageInstallStatus)();
  const {
    data: packagePoliciesData
  } = (0, _hooks.useGetPackagePoliciesQuery)({
    perPage: _constants.SO_SEARCH_LIMIT,
    page: 1,
    kuery: `${_constants.PACKAGE_POLICY_SAVED_OBJECT_TYPE}.package.name:${name}`
  });
  const {
    changelog,
    breakingChanges,
    isLoading: isChangelogLoading,
    error: changelogError
  } = (0, _hooks2.useChangelog)(name, latestVersion, version);
  const packagePolicyIds = (0, _react.useMemo)(() => packagePoliciesData === null || packagePoliciesData === void 0 ? void 0 : packagePoliciesData.items.map(({
    id
  }) => id), [packagePoliciesData]);
  const agentPolicyIds = (0, _react.useMemo)(() => {
    var _packagePoliciesData$;
    return (_packagePoliciesData$ = packagePoliciesData === null || packagePoliciesData === void 0 ? void 0 : packagePoliciesData.items.flatMap(packagePolicy => packagePolicy.policy_ids)) !== null && _packagePoliciesData$ !== void 0 ? _packagePoliciesData$ : [];
  }, [packagePoliciesData]);
  const {
    data: dryRunData
  } = (0, _hooks.useUpgradePackagePolicyDryRunQuery)(packagePolicyIds !== null && packagePolicyIds !== void 0 ? packagePolicyIds : [], latestVersion, {
    enabled: packagePolicyIds && packagePolicyIds.length > 0
  });
  const updatePackageMutation = (0, _hooks.useUpdatePackageMutation)();
  const {
    notifications
  } = (0, _hooks.useStartServices)();
  const shouldShowKeepPoliciesUpToDateSwitch = (0, _react.useMemo)(() => {
    return _constants.KEEP_POLICIES_UP_TO_DATE_PACKAGES.some(pkg => pkg.name === name);
  }, [name]);
  const isShowKeepPoliciesUpToDateSwitchDisabled = (0, _react.useMemo)(() => {
    return !authz.integrations.writePackageSettings || _constants.AUTO_UPGRADE_POLICIES_PACKAGES.some(pkg => pkg.name === name);
  }, [authz.integrations.writePackageSettings, name]);
  const [keepPoliciesUpToDateSwitchValue, setKeepPoliciesUpToDateSwitchValue] = (0, _react.useState)(keepPoliciesUpToDate !== null && keepPoliciesUpToDate !== void 0 ? keepPoliciesUpToDate : false);
  const handleKeepPoliciesUpToDateSwitchChange = (0, _react.useCallback)(() => {
    setKeepPoliciesUpToDateSwitchValue(prev => !prev);
    updatePackageMutation.mutate({
      pkgName: packageInfo.name,
      pkgVersion: packageInfo.version,
      body: {
        keepPoliciesUpToDate: !keepPoliciesUpToDateSwitchValue
      }
    }, {
      onSuccess: () => {
        notifications.toasts.addSuccess({
          title: _i18n.i18n.translate('xpack.fleet.integrations.integrationSaved', {
            defaultMessage: 'Integration settings saved'
          }),
          text: !keepPoliciesUpToDateSwitchValue ? _i18n.i18n.translate('xpack.fleet.integrations.keepPoliciesUpToDateEnabledSuccess', {
            defaultMessage: 'Fleet will automatically keep integration policies up to date for {title}',
            values: {
              title
            }
          }) : _i18n.i18n.translate('xpack.fleet.integrations.keepPoliciesUpToDateDisabledSuccess', {
            defaultMessage: 'Fleet will not automatically keep integration policies up to date for {title}',
            values: {
              title
            }
          })
        });
      },
      onError: error => {
        notifications.toasts.addError(error, {
          title: _i18n.i18n.translate('xpack.fleet.integrations.integrationSavedError', {
            defaultMessage: 'Error saving integration settings'
          }),
          toastMessage: _i18n.i18n.translate('xpack.fleet.integrations.keepPoliciesUpToDateError', {
            defaultMessage: 'Error saving integration settings for {title}',
            values: {
              title
            }
          })
        });
      }
    });
  }, [keepPoliciesUpToDateSwitchValue, notifications.toasts, packageInfo.name, packageInfo.version, title, updatePackageMutation]);
  const {
    status: installationStatus,
    version: installedVersion
  } = getPackageInstallStatus(name);
  const updateAvailable = installedVersion && (0, _lt.default)(installedVersion, latestVersion) ? true : false;
  const isViewingOldPackage = version < latestVersion;
  // hide install/remove options if the user has version of the package is installed
  // and this package is out of date or if they do have a version installed but it's not this one
  const hideInstallOptions = installationStatus === _types.InstallStatus.notInstalled && isViewingOldPackage || installationStatus === _types.InstallStatus.installed && installedVersion !== version;
  const isUpdating = installationStatus === _types.InstallStatus.installing && installedVersion;
  (0, _react.useEffect)(() => {
    if (changelogError) {
      notifications.toasts.addError(changelogError, {
        title: _i18n.i18n.translate('xpack.fleet.epm.errorLoadingChangelog', {
          defaultMessage: 'Error loading changelog information'
        })
      });
    }
  }, [changelogError, notifications.toasts]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 237,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_side_bar_column.SideBarColumn, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 7,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrations.settings.packageSettingsTitle",
    defaultMessage: "Settings",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 19
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 15
    }
  }), installedVersion !== null && /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 253,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrations.settings.packageVersionTitle",
    defaultMessage: "{title} version",
    values: {
      title
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 23
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 263,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement("table", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 264,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement("tbody", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 265,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement("tr", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 266,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(SettingsTitleCell, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrations.settings.versionInfo.installedVersion",
    defaultMessage: "Installed version",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 268,
      columnNumber: 27
    }
  })), /*#__PURE__*/_react.default.createElement("td", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 273,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    "data-test-subj": "epmSettings.installedVersionTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 274,
      columnNumber: 27
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 275,
      columnNumber: 29
    }
  }, installedVersion)))), /*#__PURE__*/_react.default.createElement("tr", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 279,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(SettingsTitleCell, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 280,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrations.settings.versionInfo.latestVersion",
    defaultMessage: "Latest version",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 281,
      columnNumber: 27
    }
  })), /*#__PURE__*/_react.default.createElement("td", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 286,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    "data-test-subj": "epmSettings.latestVersionTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 287,
      columnNumber: 27
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 288,
      columnNumber: 29
    }
  }, latestVersion)))))), shouldShowKeepPoliciesUpToDateSwitch && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_components.KeepPoliciesUpToDateSwitch, {
    checked: keepPoliciesUpToDateSwitchValue,
    onChange: handleKeepPoliciesUpToDateSwitchChange,
    disabled: isShowKeepPoliciesUpToDateSwitchDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 296,
      columnNumber: 23
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 301,
      columnNumber: 23
    }
  })), (updateAvailable || isUpgradingPackagePolicies) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_update_available_callout.UpdateAvailableCallout, {
    version: latestVersion,
    toggleChangelogModal: toggleChangelogModal,
    breakingChanges: breakingChanges ? {
      changelog: breakingChanges,
      isUnderstood: isBreakingChangesUnderstood,
      toggleIsUnderstood: () => setIsBreakingChangesUnderstood(prev => !prev),
      onOpen: () => setIsBreakingChangesFlyoutOpen(true)
    } : null,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 307,
      columnNumber: 23
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 322,
      columnNumber: 23
    }
  }), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 323,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_update_button.UpdateButton, (0, _extends2.default)({}, packageInfo, {
    version: latestVersion,
    agentPolicyIds: agentPolicyIds,
    packagePolicyIds: packagePolicyIds,
    dryRunData: dryRunData,
    isUpgradingPackagePolicies: isUpgradingPackagePolicies,
    setIsUpgradingPackagePolicies: setIsUpgradingPackagePolicies,
    startServices: startServices,
    isDisabled: Boolean(breakingChanges) && !isBreakingChangesUnderstood,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 324,
      columnNumber: 25
    }
  }))))), !hideInstallOptions && !isUpdating && /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 341,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 342,
      columnNumber: 19
    }
  }), installationStatus === _types.InstallStatus.notInstalled || installationStatus === _types.InstallStatus.installing ? /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 345,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 346,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 347,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrations.settings.packageInstallTitle",
    defaultMessage: "Install {title}",
    values: {
      title
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 348,
      columnNumber: 27
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 357,
      columnNumber: 23
    }
  }), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 358,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrations.settings.packageInstallDescription",
    defaultMessage: "Install this integration to setup Kibana and Elasticsearch assets designed for {title} data.",
    values: {
      title
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 359,
      columnNumber: 25
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 367,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 368,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 369,
      columnNumber: 27
    }
  }, /*#__PURE__*/_react.default.createElement(_install_button.InstallButton, (0, _extends2.default)({}, packageInfo, {
    disabled: packageMetadata === null || packageMetadata === void 0 ? void 0 : packageMetadata.has_policies,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 370,
      columnNumber: 29
    }
  })))))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 380,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 381,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 382,
      columnNumber: 27
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 383,
      columnNumber: 29
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrations.settings.packageUninstallTitle",
    defaultMessage: "Uninstall",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 384,
      columnNumber: 31
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 391,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrations.settings.packageUninstallDescription",
    defaultMessage: "Remove Kibana and Elasticsearch assets that were installed by this integration.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 392,
      columnNumber: 27
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 397,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 398,
      columnNumber: 27
    }
  }, /*#__PURE__*/_react.default.createElement(_uninstall_button.UninstallButton, (0, _extends2.default)({}, packageInfo, {
    latestVersion: latestVersion,
    disabled: packageMetadata === null || packageMetadata === void 0 ? void 0 : packageMetadata.has_policies,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 399,
      columnNumber: 29
    }
  })))), (packageMetadata === null || packageMetadata === void 0 ? void 0 : packageMetadata.has_policies) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 407,
      columnNumber: 27
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 408,
      columnNumber: 29
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrations.settings.packageUninstallNoteDescription.packageUninstallNoteDetail",
    defaultMessage: "{strongNote} {title} cannot be uninstalled because there are active agents that use this integration. To uninstall, remove all {title} integrations from your agent policies.",
    values: {
      title,
      strongNote: /*#__PURE__*/_react.default.createElement(NoteLabel, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 414,
          columnNumber: 47
        }
      })
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 409,
      columnNumber: 31
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 421,
      columnNumber: 23
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 422,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 423,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 424,
      columnNumber: 27
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 425,
      columnNumber: 29
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrations.settings.packageReinstallTitle",
    defaultMessage: "Reinstall",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 426,
      columnNumber: 31
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 433,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrations.settings.packageReinstallDescription",
    defaultMessage: "Reinstall Kibana and Elasticsearch assets for this integration.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 434,
      columnNumber: 27
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 439,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 440,
      columnNumber: 27
    }
  }, /*#__PURE__*/_react.default.createElement(_reinstall_button.ReinstallButton, (0, _extends2.default)({}, packageInfo, {
    installSource: 'installationInfo' in packageInfo && (_packageInfo$installa = packageInfo.installationInfo) !== null && _packageInfo$installa !== void 0 && _packageInfo$installa.install_source ? packageInfo.installationInfo.install_source : '',
    isCustomPackage: isCustomPackage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 441,
      columnNumber: 29
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 454,
      columnNumber: 23
    }
  }), enablePackageRollback && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 457,
      columnNumber: 27
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 458,
      columnNumber: 29
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 459,
      columnNumber: 31
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 460,
      columnNumber: 33
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrations.settings.packageRollbackTitle",
    defaultMessage: "Rollback",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 461,
      columnNumber: 35
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 468,
      columnNumber: 29
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrations.settings.packageRollbackDescription",
    defaultMessage: "Rollback integration to the previous version.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 469,
      columnNumber: 31
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 474,
      columnNumber: 29
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 475,
      columnNumber: 31
    }
  }, /*#__PURE__*/_react.default.createElement(_use_bulk_actions_context.BulkActionContextProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 476,
      columnNumber: 33
    }
  }, /*#__PURE__*/_react.default.createElement(_rollback_button.RollbackButton, {
    packageInfo: packageInfo,
    isCustomPackage: isCustomPackage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 477,
      columnNumber: 35
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 485,
      columnNumber: 27
    }
  })))), hideInstallOptions && isViewingOldPackage && !isUpdating && /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 493,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 494,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 495,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 496,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 497,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrations.settings.packageInstallTitle",
    defaultMessage: "Install {title}",
    values: {
      title
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 498,
      columnNumber: 25
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 507,
      columnNumber: 21
    }
  }), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 508,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 509,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrations.settings.packageSettingsOldVersionMessage",
    defaultMessage: "Version {version} is out of date. The {latestVersion} of this integration is available to be installed.",
    values: {
      version,
      latestVersion: /*#__PURE__*/_react.default.createElement(LatestVersionLink, {
        name: name,
        version: latestVersion,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 516,
          columnNumber: 31
        }
      })
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 510,
      columnNumber: 25
    }
  })))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 528,
      columnNumber: 9
    }
  }, isChangelogModalOpen && /*#__PURE__*/_react.default.createElement(_changelog_modal.ChangelogModal, {
    changelog: changelog,
    isLoading: isChangelogLoading,
    onClose: toggleChangelogModal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 530,
      columnNumber: 13
    }
  })), isBreakingChangesFlyoutOpen && breakingChanges && /*#__PURE__*/_react.default.createElement(_breaking_changes_flyout.BreakingChangesFlyout, {
    breakingChanges: breakingChanges,
    onClose: () => setIsBreakingChangesFlyoutOpen(false),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 538,
      columnNumber: 11
    }
  }));
});