"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentlessPackagePoliciesTable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _reactRouterDom = require("react-router-dom");
var _constants = require("../../../../../../../../../common/constants");
var _hooks = require("../../../../../../hooks");
var _components = require("../../../../../../components");
var _persona = require("../persona");
var _components2 = require("../../../../../../../fleet/sections/agents/components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/integrations/sections/epm/screens/detail/policies/components/agentless_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const REFRESH_INTERVAL_MS = 30000;
const AgentlessPackagePoliciesTable = ({
  isLoading,
  packagePolicies,
  packagePoliciesTotal,
  refreshPackagePolicies,
  pagination
}) => {
  const core = (0, _hooks.useStartServices)();
  const {
    notifications
  } = core;
  const authz = (0, _hooks.useAuthz)();
  const {
    getHref
  } = (0, _hooks.useLink)();
  const [isAgentsLoading, setIsAgentsLoading] = (0, _react.useState)(false);
  const [agentsByPolicyId, setAgentsByPolicyId] = (0, _react.useState)({});
  const canReadAgents = authz.fleet.readAgents;
  const canWriteIntegrationPolicies = authz.integrations.writeIntegrationPolicies;

  // Kuery for all agents enrolled into the agent policies associated with the package policies
  // We use the first agent policy as agentless package policies have a 1:1 relationship with agent policies
  // Maximum # of agent policies is 50, based on the max page size in UI
  const agentsKuery = (0, _react.useMemo)(() => {
    return packagePolicies.reduce((policyIds, {
      agentPolicies
    }) => {
      var _agentPolicies$;
      return [...policyIds, ...(agentPolicies[0] ? [(_agentPolicies$ = agentPolicies[0]) === null || _agentPolicies$ === void 0 ? void 0 : _agentPolicies$.id] : [])];
    }, []).map(policyId => `${_constants.AGENTS_PREFIX}.policy_id: "${policyId}"`).join(' or ');
  }, [packagePolicies]);

  // Fetch agents using above kuery, if the user has access to read agents
  // Polls every 30 seconds
  (0, _react.useEffect)(() => {
    const fetchAgents = async () => {
      const {
        data: agentsData,
        error
      } = await (0, _hooks.sendGetAgents)({
        perPage: _constants.SO_SEARCH_LIMIT,
        kuery: agentsKuery
      });
      setAgentsByPolicyId(((agentsData === null || agentsData === void 0 ? void 0 : agentsData.items) || []).reduce((acc, agent) => {
        if (agent.policy_id) {
          acc[agent.policy_id] = agent;
        }
        return acc;
      }, {}));
      if (error) {
        notifications.toasts.addError(error, {
          title: _i18n.i18n.translate('xpack.fleet.epm.packageDetails.integrationList.agentlessStatusError', {
            defaultMessage: 'Error fetching agentless status information'
          })
        });
      }
      setIsAgentsLoading(false);
    };
    if (canReadAgents) {
      setIsAgentsLoading(true);
      fetchAgents();
      const interval = setInterval(() => {
        fetchAgents();
      }, REFRESH_INTERVAL_MS);
      return () => clearInterval(interval);
    }
  }, [agentsKuery, canReadAgents, notifications.toasts]);

  // Flyout state
  const {
    search
  } = (0, _reactRouterDom.useLocation)();
  const queryParams = (0, _react.useMemo)(() => new URLSearchParams(search), [search]);
  const [flyoutOpenForPolicyId, setFlyoutOpenForPolicyId] = (0, _react.useState)();
  const [flyoutPackagePolicy, setFlyoutPackagePolicy] = (0, _react.useState)();
  const [flyoutAgentPolicy, setFlyoutAgentPolicy] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    const flyoutAgentPolicyIdFromQuery = queryParams.get('openEnrollmentFlyout');
    if (flyoutAgentPolicyIdFromQuery) {
      const pp = packagePolicies.find(p => p.packagePolicy.policy_ids.includes(flyoutAgentPolicyIdFromQuery));
      if (pp) {
        setFlyoutOpenForPolicyId(flyoutAgentPolicyIdFromQuery);
        setFlyoutPackagePolicy(pp.packagePolicy);
        setFlyoutAgentPolicy(pp.agentPolicies[0]);
      }
    }
  }, [packagePolicies, queryParams]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: packagePolicies || [],
    columns: [{
      field: 'packagePolicy.name',
      name: _i18n.i18n.translate('xpack.fleet.epm.packageDetails.integrationList.name', {
        defaultMessage: 'Integration policy'
      }),
      render(_, {
        agentPolicies,
        packagePolicy
      }) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          className: "eui-textTruncate",
          "data-test-subj": "agentlessIntegrationNameLink",
          href: getHref('integration_policy_edit', {
            packagePolicyId: packagePolicy.id
          }),
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 158,
            columnNumber: 17
          }
        }, packagePolicy.name);
      }
    }, {
      field: 'packagePolicy.package.version',
      name: _i18n.i18n.translate('xpack.fleet.epm.packageDetails.integrationList.version', {
        defaultMessage: 'Version'
      }),
      render(_version, {
        agentPolicies,
        packagePolicy
      }) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "s",
          alignItems: "center",
          wrap: true,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 177,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 178,
            columnNumber: 19
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "s",
          className: "eui-textNoWrap",
          "data-test-subj": "packageVersionText",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 179,
            columnNumber: 21
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.epm.packageDetails.integrationList.packageVersion",
          defaultMessage: "v{version}",
          values: {
            version: _version
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 184,
            columnNumber: 23
          }
        }))), agentPolicies.length > 0 && packagePolicy.hasUpgrade && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 193,
            columnNumber: 21
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
          size: "s",
          minWidth: "0",
          href: `${getHref('upgrade_package_policy', {
            policyId: agentPolicies[0].id,
            packagePolicyId: packagePolicy.id
          })}?from=integrations-policy-list`,
          "data-test-subj": "integrationPolicyUpgradeBtn",
          isDisabled: !canWriteIntegrationPolicies,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 194,
            columnNumber: 23
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.policyDetails.packagePoliciesTable.upgradeButton",
          defaultMessage: "Upgrade",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 204,
            columnNumber: 25
          }
        }))));
      }
    }, {
      field: 'packagePolicy.updated_by',
      name: _i18n.i18n.translate('xpack.fleet.epm.packageDetails.integrationList.updatedBy', {
        defaultMessage: 'Last updated by'
      }),
      truncateText: true,
      render(updatedBy) {
        return /*#__PURE__*/_react.default.createElement(_persona.Persona, {
          size: "s",
          name: updatedBy,
          title: updatedBy,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 222,
            columnNumber: 22
          }
        });
      }
    }, {
      field: 'packagePolicy.updated_at',
      name: _i18n.i18n.translate('xpack.fleet.epm.packageDetails.integrationList.updatedAt', {
        defaultMessage: 'Last updated'
      }),
      truncateText: true,
      render(updatedAt) {
        return /*#__PURE__*/_react.default.createElement("span", {
          className: "eui-textTruncate",
          title: updatedAt,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 233,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedRelative, {
          value: updatedAt,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 234,
            columnNumber: 19
          }
        }));
      }
    }, ...(canReadAgents ? [{
      field: '',
      name: _i18n.i18n.translate('xpack.fleet.epm.packageDetails.integrationList.agentlessStatus', {
        defaultMessage: 'Status'
      }),
      align: 'left',
      render({
        agentPolicies,
        packagePolicy
      }) {
        if (isAgentsLoading) {
          return /*#__PURE__*/_react.default.createElement(_components.Loading, {
            size: "s",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 259,
              columnNumber: 30
            }
          });
        }
        // Use the first agent policy ID associated with the package policy
        // because agentless package policies are only associated with one agent policy
        const agentPolicy = agentPolicies[0];
        const agent = (agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.id) && agentsByPolicyId[agentPolicy.id] || undefined;

        // Status badge click handler
        const statusBadgeProps = {
          onClick: () => {
            setFlyoutOpenForPolicyId(packagePolicy.id);
            setFlyoutPackagePolicy(packagePolicy);
            setFlyoutAgentPolicy(agentPolicy);
          },
          'data-test-subj': 'agentlessStatusBadge',
          onClickAriaLabel: _i18n.i18n.translate('xpack.fleet.epm.packageDetails.integrationList.agentlessStatusAriaLabel', {
            defaultMessage: 'Open status details'
          })
        };
        return agent ? /*#__PURE__*/_react.default.createElement(_components2.AgentHealth, (0, _extends2.default)({
          agent: agent
        }, statusBadgeProps, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 284,
            columnNumber: 23
          }
        })) : /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({
          color: "default"
        }, statusBadgeProps, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 286,
            columnNumber: 23
          }
        }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.packageDetails.integrationList.pendingAgentlessStatus",
          defaultMessage: "Pending",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 287,
            columnNumber: 25
          }
        }));
      }
    }] : []), {
      field: '',
      name: _i18n.i18n.translate('xpack.fleet.epm.packageDetails.integrationList.actions', {
        defaultMessage: 'Actions'
      }),
      width: '8ch',
      align: 'right',
      render({
        agentPolicies,
        packagePolicy
      }) {
        const agentPolicy = agentPolicies[0]; // TODO: handle multiple agent policies
        return /*#__PURE__*/_react.default.createElement(_components.PackagePolicyActionsMenu, {
          agentPolicies: agentPolicies,
          packagePolicy: packagePolicy,
          showAddAgent: true,
          upgradePackagePolicyHref: agentPolicy ? `${getHref('upgrade_package_policy', {
            policyId: agentPolicy.id,
            packagePolicyId: packagePolicy.id
          })}?from=integrations-policy-list` : undefined,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 313,
            columnNumber: 17
          }
        });
      }
    }],
    loading: isLoading,
    "data-test-subj": "integrationPolicyTable",
    pagination: {
      pageIndex: pagination.pagination.currentPage - 1,
      pageSize: pagination.pagination.pageSize,
      totalItemCount: packagePoliciesTotal,
      pageSizeOptions: pagination.pageSizeOptions
    },
    onChange: ({
      page
    }) => {
      pagination.setPagination({
        currentPage: page.index + 1,
        pageSize: page.size
      });
    },
    noItemsMessage: isLoading ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epm.packageDetails.integrationList.loadingPoliciesMessage",
      defaultMessage: "Loading integration policies\u2026",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 346,
        columnNumber: 13
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epm.packageDetails.integrationList.noAgentlessPoliciesMessage",
      defaultMessage: "No agentless integration policies",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 351,
        columnNumber: 13
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 7
    }
  }), flyoutOpenForPolicyId && flyoutPackagePolicy && /*#__PURE__*/_react.default.createElement(_components.AgentlessEnrollmentFlyout, {
    onClose: () => {
      setFlyoutOpenForPolicyId(undefined);
      setFlyoutPackagePolicy(undefined);
      setFlyoutAgentPolicy(undefined);
    },
    packagePolicy: flyoutPackagePolicy,
    agentPolicy: flyoutAgentPolicy,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 359,
      columnNumber: 9
    }
  }));
};
exports.AgentlessPackagePoliciesTable = AgentlessPackagePoliciesTable;