"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdvancedSection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _hooks = require("../../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/settings/components/settings_page/advanced_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AdvancedSection = ({}) => {
  var _useGetSettings$data$, _useGetSettings$data, _useGetSettings$data$2, _useGetSettings$data$3, _useGetSettings$data$4, _useGetSettings$data2, _useGetSettings$data3, _useGetSettings$data4;
  const authz = (0, _hooks.useAuthz)();
  const fleetStatus = (0, _hooks.useFleetStatus)();
  const {
    docLinks,
    notifications,
    overlays
  } = (0, _hooks.useStartServices)();
  const deleteUnenrolledAgents = (_useGetSettings$data$ = (_useGetSettings$data = (0, _hooks.useGetSettings)().data) === null || _useGetSettings$data === void 0 ? void 0 : (_useGetSettings$data$2 = _useGetSettings$data.item) === null || _useGetSettings$data$2 === void 0 ? void 0 : (_useGetSettings$data$3 = _useGetSettings$data$2.delete_unenrolled_agents) === null || _useGetSettings$data$3 === void 0 ? void 0 : _useGetSettings$data$3.enabled) !== null && _useGetSettings$data$ !== void 0 ? _useGetSettings$data$ : false;
  const isPreconfigured = (_useGetSettings$data$4 = (_useGetSettings$data2 = (0, _hooks.useGetSettings)().data) === null || _useGetSettings$data2 === void 0 ? void 0 : (_useGetSettings$data3 = _useGetSettings$data2.item) === null || _useGetSettings$data3 === void 0 ? void 0 : (_useGetSettings$data4 = _useGetSettings$data3.delete_unenrolled_agents) === null || _useGetSettings$data4 === void 0 ? void 0 : _useGetSettings$data4.is_preconfigured) !== null && _useGetSettings$data$4 !== void 0 ? _useGetSettings$data$4 : false;
  const [deleteUnenrolledAgentsChecked, setDeleteUnenrolledAgentsChecked] = _react.default.useState(deleteUnenrolledAgents);
  const {
    mutateAsync: mutateSettingsAsync
  } = (0, _hooks.usePutSettingsMutation)();

  // Agentless resources toggle state
  const {
    showAgentless,
    setShowAgentless
  } = (0, _hooks.useAgentlessResources)();
  const {
    mutateAsync: mutateSpaceAwarenessAsync,
    isLoading: mutateSpaceAwarenessIsLoading
  } = (0, _hooks.useMigrateSpaceAwarenessMutation)();
  (0, _react.useEffect)(() => {
    if (deleteUnenrolledAgents) {
      setDeleteUnenrolledAgentsChecked(deleteUnenrolledAgents);
    }
  }, [deleteUnenrolledAgents]);
  const updateSettings = (0, _react.useCallback)(async deleteFlag => {
    try {
      setDeleteUnenrolledAgentsChecked(deleteFlag);
      const res = await mutateSettingsAsync({
        delete_unenrolled_agents: {
          enabled: deleteFlag,
          is_preconfigured: false
        }
      });
      if (res.error) {
        throw res.error;
      }
    } catch (error) {
      setDeleteUnenrolledAgentsChecked(!deleteFlag);
      notifications.toasts.addError(error, {
        title: _i18n.i18n.translate('xpack.fleet.errorUpdatingSettings', {
          defaultMessage: 'Error updating settings'
        })
      });
    }
  }, [mutateSettingsAsync, notifications.toasts]);
  const onClickEnableSpaceAwareness = (0, _react.useCallback)(async () => {
    const confirmRes = await overlays.openConfirm(_i18n.i18n.translate('xpack.fleet.confirmSpaceAwarenessMigrationMessage', {
      defaultMessage: 'This migration will enable each space to have its own agent policy and agents. This is a one-way migration and can’t be reversed.'
    }), {
      title: _i18n.i18n.translate('xpack.fleet.confirmSpaceAwarenessMigrationTitle', {
        defaultMessage: 'Migrate to Space-Aware Agent Policies?'
      }),
      buttonColor: 'warning',
      confirmButtonText: _i18n.i18n.translate('xpack.fleet.confirmSpaceAwarenessMigration.confirmButtonText', {
        defaultMessage: 'Confirm and migrate'
      })
    });
    if (!confirmRes) {
      return;
    }
    try {
      await mutateSpaceAwarenessAsync();
      notifications.toasts.addSuccess({
        title: _i18n.i18n.translate('xpack.fleet.confirmSpaceAwarenessMigration.successToastTitle', {
          defaultMessage: 'Migration complete'
        }),
        text: _i18n.i18n.translate('xpack.fleet.confirmSpaceAwarenessMigration.successToastContent', {
          defaultMessage: 'Your cluster now uses space-aware agent policies.'
        })
      });
    } catch (error) {
      notifications.toasts.addError(error, {
        title: _i18n.i18n.translate('xpack.fleet.confirmSpaceAwarenessMigration.errorToastTitle', {
          defaultMessage: 'Migration failed'
        })
      });
    }
  }, [mutateSpaceAwarenessAsync, notifications.toasts, overlays]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    "data-test-subj": "advancedHeader",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.advancedSectionTitle",
    defaultMessage: "Advanced Settings",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 11
    }
  }))), fleetStatus.isSpaceAwarenessEnabled ? null : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.migrateSpaceAwarenessLabel",
      defaultMessage: "Migrate to space-aware agent policies",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 144,
        columnNumber: 17
      }
    })),
    description: /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 151,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.advancedSection.switchLabel",
      defaultMessage: "Take advantage of improved isolation and management by enabling space-specific agent policies.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 17
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: onClickEnableSpaceAwareness,
    isLoading: mutateSpaceAwarenessIsLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.deleteUnenrolledAgentsLabel",
    defaultMessage: "Start migration",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 17
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 178,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.deleteUnenrolledAgentsLabel",
      defaultMessage: "Delete unenrolled agents",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 179,
        columnNumber: 13
      }
    })),
    description: /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 186,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.advancedSection.switchLabel",
      defaultMessage: "Switching on this setting will enable auto-deletion of unenrolled agents. For more information, refer to the {docLink}.",
      values: {
        docLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          target: "_blank",
          external: true,
          href: docLinks.links.fleet.settings,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 192,
            columnNumber: 19
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.settings.advancedSection.link",
          defaultMessage: "docs",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 193,
            columnNumber: 21
          }
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 187,
        columnNumber: 13
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: isPreconfigured ? _i18n.i18n.translate('xpack.fleet.settings.advancedSection.preconfiguredTitle', {
      defaultMessage: 'This setting is preconfigured and cannot be updated.'
    }) : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.deleteUnenrolledAgentsLabel",
      defaultMessage: "Delete unenrolled agents",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 216,
        columnNumber: 17
      }
    }),
    checked: deleteUnenrolledAgentsChecked,
    onChange: e => updateSettings(e.target.checked),
    disabled: !authz.fleet.allSettings || isPreconfigured,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 233,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.showAgentlessResourcesLabel",
      defaultMessage: "Show agentless resources",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 234,
        columnNumber: 13
      }
    })),
    description: /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 241,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.showAgentlessResourcesDescription",
      defaultMessage: "Enable this toggle to display agentless agents and policies in Fleet for debugging and diagnostics purposes. This setting is stored locally and is only visible to you.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 242,
        columnNumber: 13
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.showAgentlessResourcesLabel",
      defaultMessage: "Show agentless resources",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 252,
        columnNumber: 15
      }
    }),
    checked: showAgentless,
    onChange: e => {
      setShowAgentless(e.target.checked);
      setShowAgentless(e.target.checked);
    },
    "data-test-subj": "showAgentlessResourcesSwitch",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 7
    }
  }));
};
exports.AdvancedSection = AdvancedSection;