"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateAgentPolicyFlyout = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _use_space_settings_context = require("../../../../../../hooks/use_space_settings_context");
var _constants = require("../../../../constants");
var _hooks = require("../../../../hooks");
var _components = require("../../components");
var _components2 = require("../../../../components");
var _services = require("../../services");
var _generate_new_agent_policy = require("../../../../../../../common/services/generate_new_agent_policy");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agent_policy/list_page/components/create_agent_policy.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FlyoutWithHigherZIndex = (0, _styledComponents.default)(_eui.EuiFlyout)`
  z-index: ${props => props.theme.eui.euiZLevel5};
`;
const CreateAgentPolicyFlyout = ({
  onClose,
  as,
  ...restOfProps
}) => {
  const {
    notifications
  } = (0, _hooks.useStartServices)();
  const hasFleetAllAgentPoliciesPrivileges = (0, _hooks.useAuthz)().fleet.allAgentPolicies;
  const spaceSettings = (0, _use_space_settings_context.useSpaceSettingsContext)();
  const [agentPolicy, setAgentPolicy] = (0, _react.useState)((0, _generate_new_agent_policy.generateNewAgentPolicyWithDefaults)({
    namespace: spaceSettings.defaultNamespace
  }));
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [withSysMonitoring, setWithSysMonitoring] = (0, _react.useState)(true);
  const validation = (0, _components.agentPolicyFormValidation)(agentPolicy, {
    allowedNamespacePrefixes: spaceSettings === null || spaceSettings === void 0 ? void 0 : spaceSettings.allowedNamespacePrefixes
  });
  const [hasAdvancedSettingsErrors, setHasAdvancedSettingsErrors] = (0, _react.useState)(false);
  const [hasInvalidSpaceError, setInvalidSpaceError] = (0, _react.useState)(false);
  const updateAgentPolicy = updatedFields => {
    setAgentPolicy({
      ...agentPolicy,
      ...updatedFields
    });
  };
  const createAgentPolicy = async () => {
    return await (0, _hooks.sendCreateAgentPolicy)(agentPolicy, {
      withSysMonitoring
    });
  };
  const header = /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    "aria-labelledby": "CreateAgentPolicyFlyoutTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "CreateAgentPolicyFlyoutTitle",
    "data-test-subj": "createAgentPolicyFlyoutTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.createAgentPolicy.flyoutTitle",
    defaultMessage: "Create agent policy",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.createAgentPolicy.flyoutTitleDescription",
    defaultMessage: "Agent policies are used to manage settings across a group of agents. You can add integrations to your agent policy to specify what data your agents collect. When you edit an agent policy, you can use Fleet to deploy updates to a specified group of agents.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 11
    }
  }))));
  const body = /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_components.AgentPolicyForm, {
    agentPolicy: agentPolicy,
    updateAgentPolicy: updateAgentPolicy,
    withSysMonitoring: withSysMonitoring,
    updateSysMonitoring: newValue => setWithSysMonitoring(newValue),
    validation: validation,
    updateAdvancedSettingsHasErrors: setHasAdvancedSettingsErrors,
    setInvalidSpaceError: setInvalidSpaceError,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 7
    }
  }));
  const agentPolicyContent = (0, _react.useMemo)(() => (0, _services.generateCreateAgentPolicyDevToolsRequest)(agentPolicy, withSysMonitoring), [agentPolicy, withSysMonitoring]);
  const footer = /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => onClose(),
    flush: "left",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.createAgentPolicy.cancelButtonLabel",
    defaultMessage: "Cancel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_components2.DevtoolsRequestFlyoutButton, {
    isDisabled: isLoading || Object.keys(validation).length > 0 || hasAdvancedSettingsErrors || hasInvalidSpaceError,
    description: _i18n.i18n.translate('xpack.fleet.createAgentPolicy.devtoolsRequestDescription', {
      defaultMessage: 'This Kibana request creates a new agent policy.'
    }),
    request: agentPolicyContent,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    isLoading: isLoading,
    isDisabled: !hasFleetAllAgentPoliciesPrivileges || isLoading || Object.keys(validation).length > 0 || hasAdvancedSettingsErrors || hasInvalidSpaceError,
    onClick: async () => {
      setIsLoading(true);
      try {
        const {
          data,
          error
        } = await createAgentPolicy();
        setIsLoading(false);
        if (data) {
          notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.fleet.createAgentPolicy.successNotificationTitle', {
            defaultMessage: "Agent policy ''{name}'' created",
            values: {
              name: agentPolicy.name
            }
          }));
          onClose(data.item);
        } else {
          notifications.toasts.addDanger(error ? error.message : _i18n.i18n.translate('xpack.fleet.createAgentPolicy.errorNotificationTitle', {
            defaultMessage: 'Unable to create agent policy'
          }));
        }
      } catch (e) {
        setIsLoading(false);
        notifications.toasts.addDanger(_i18n.i18n.translate('xpack.fleet.createAgentPolicy.errorNotificationTitle', {
          defaultMessage: 'Unable to create agent policy'
        }));
      }
    },
    "data-test-subj": "createAgentPolicyFlyoutBtn",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.createAgentPolicy.submitButtonLabel",
    defaultMessage: "Create agent policy",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 17
    }
  })))))));
  return /*#__PURE__*/_react.default.createElement(FlyoutWithHigherZIndex, (0, _extends2.default)({
    onClose: () => onClose()
  }, restOfProps, {
    maxWidth: _constants.MAX_FLYOUT_WIDTH,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 5
    }
  }), header, body, footer);
};
exports.CreateAgentPolicyFlyout = CreateAgentPolicyFlyout;