"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PostInstallAzureArmTemplateModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _reactQuery = require("@kbn/react-query");
var _cloud_security_posture = require("../../../../../../../../components/cloud_security_posture");
var _services = require("../../../../../../../../components/cloud_security_posture/services");
var _hooks = require("../../../../../../../../components/cloud_security_posture/hooks");
var _hooks2 = require("../../../../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agent_policy/create_package_policy_page/single_page_layout/components/cloud_security_posture/post_install_azure_arm_template_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const PostInstallAzureArmTemplateModal = ({
  onConfirm,
  onCancel,
  agentPolicy,
  packagePolicy
}) => {
  var _apyKeysData$data, _apyKeysData$data$ite;
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const {
    data: apyKeysData
  } = (0, _reactQuery.useQuery)(['azureArmTemplateApiKeys', {
    agentPolicyId: agentPolicy.id
  }], () => (0, _hooks2.sendGetEnrollmentAPIKeys)({
    page: 1,
    perPage: 1,
    kuery: `policy_id:"${agentPolicy.id}"`
  }));
  const azureArmTemplateProps = (0, _services.getAzureArmPropsFromPackagePolicy)(packagePolicy);
  const enrollmentToken = apyKeysData === null || apyKeysData === void 0 ? void 0 : (_apyKeysData$data = apyKeysData.data) === null || _apyKeysData$data === void 0 ? void 0 : (_apyKeysData$data$ite = _apyKeysData$data.items[0]) === null || _apyKeysData$data$ite === void 0 ? void 0 : _apyKeysData$data$ite.api_key;
  const {
    azureArmTemplateUrl,
    error,
    isError,
    isLoading
  } = (0, _hooks.useCreateAzureArmTemplateUrl)({
    enrollmentAPIKey: enrollmentToken,
    azureArmTemplateProps
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    "data-test-subj": "postInstallAzureArmTemplateModal",
    onClose: onCancel,
    "aria-labelledby": modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    "data-test-subj": "confirmAzureArmTemplateModalTitleText",
    id: modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentPolicy.postInstallAzureArmTemplateModalModalTitle",
    defaultMessage: "ARM Template deployment",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_cloud_security_posture.AzureArmTemplateGuide, {
    azureAccountType: azureArmTemplateProps.azureAccountType,
    agentPolicy: agentPolicy,
    enrollmentToken: enrollmentToken,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 9
    }
  }), error && isError && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: error,
    color: "danger",
    iconType: "error",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "confirmAzureArmTemplateModalCancelButton",
    onClick: onCancel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentPolicy.postInstallAzureArmTemplateModal.cancelButton",
    defaultMessage: "Add ARM Template later",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "confirmAzureArmTemplateModalConfirmButton",
    onClick: () => {
      window.open(azureArmTemplateUrl);
      onConfirm();
    },
    fill: true,
    color: "primary",
    isLoading: isLoading,
    isDisabled: isError,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentPolicy.postInstallAzureArmTemplateModalConfirmButtonLabel",
    defaultMessage: "Launch ARM Template",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 11
    }
  }))));
};
exports.PostInstallAzureArmTemplateModal = PostInstallAzureArmTemplateModal;