"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.shouldShowStreamsByDefault = exports.PackagePolicyInputPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactMarkdown = _interopRequireDefault(require("react-markdown"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _services = require("../../../services");
var _setup_technology = require("../../../single_page_layout/hooks/setup_technology");
var _package_policy_input_config = require("./package_policy_input_config");
var _package_policy_input_stream = require("./package_policy_input_stream");
var _hooks = require("./hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agent_policy/create_package_policy_page/components/steps/components/package_policy_input_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ShortenedHorizontalRule = (0, _styledComponents.default)(_eui.EuiHorizontalRule)`
  &&& {
    width: ${11 / 12 * 100}%;
    margin-left: auto;
  }
`;
const shouldShowStreamsByDefault = (packageInput, packageInputStreams, packagePolicyInput, defaultDataStreamId) => {
  if (!packagePolicyInput.enabled) {
    return false;
  }
  return (0, _services.hasInvalidButRequiredVar)(packageInput.vars, packagePolicyInput.vars) || packageInputStreams.some(stream => {
    var _packagePolicyInput$s;
    return stream.enabled && (0, _services.hasInvalidButRequiredVar)(stream.vars, (_packagePolicyInput$s = packagePolicyInput.streams.find(pkgStream => stream.data_stream.dataset === pkgStream.data_stream.dataset)) === null || _packagePolicyInput$s === void 0 ? void 0 : _packagePolicyInput$s.vars);
  }) || packagePolicyInput.streams.some(stream => {
    return defaultDataStreamId && stream.id && stream.id === defaultDataStreamId;
  });
};
exports.shouldShowStreamsByDefault = shouldShowStreamsByDefault;
const PackagePolicyInputPanel = exports.PackagePolicyInputPanel = /*#__PURE__*/(0, _react.memo)(({
  packageInput,
  packageInfo,
  packageInputStreams,
  packagePolicyInput,
  updatePackagePolicyInput,
  inputValidationResults,
  forceShowErrors,
  isEditPage = false
}) => {
  var _inputStreams$, _inputStreams$$packag;
  const defaultDataStreamId = (0, _hooks.useDataStreamId)();
  const {
    isAgentlessEnabled
  } = (0, _setup_technology.useAgentless)();
  const showTopLevelDescription = packagePolicyInput.streams.length === 1;
  // Showing streams toggle state
  const [isShowingStreams, setIsShowingStreams] = (0, _react.useState)(() => shouldShowStreamsByDefault(packageInput, packageInputStreams, packagePolicyInput, defaultDataStreamId));

  // Hide registry variables based on `hide_in_deployment_modes` value
  const hideRegistryVars = (0, _react.useCallback)(registryVar => {
    var _registryVar$hide_in_, _registryVar$hide_in_2;
    if (!registryVar.hide_in_deployment_modes) return false;
    return isAgentlessEnabled && !!((_registryVar$hide_in_ = registryVar.hide_in_deployment_modes) !== null && _registryVar$hide_in_ !== void 0 && _registryVar$hide_in_.find(mode => mode === 'agentless')) || !isAgentlessEnabled && !!((_registryVar$hide_in_2 = registryVar.hide_in_deployment_modes) !== null && _registryVar$hide_in_2 !== void 0 && _registryVar$hide_in_2.find(mode => mode === 'default'));
  }, [isAgentlessEnabled]);
  const packageInputStreamShouldBeVisible = (0, _react.useCallback)(packageInputStream => {
    return !!packageInputStream.vars && packageInputStream.vars.length > 0 && !!packageInputStream.vars.find(registryVar => !hideRegistryVars(registryVar));
  }, [hideRegistryVars]);

  // Errors state
  const errorCount = inputValidationResults && (0, _services.countValidationErrors)(inputValidationResults);
  const hasErrors = forceShowErrors && errorCount;
  const hasInputStreams = (0, _react.useMemo)(() => packageInputStreams.length > 0, [packageInputStreams.length]);
  const inputStreams = (0, _react.useMemo)(() => packageInputStreams.filter(packageInputStream => packageInputStreamShouldBeVisible(packageInputStream)).map(packageInputStream => {
    return {
      packageInputStream,
      packagePolicyInputStream: packagePolicyInput.streams.find(stream => stream.data_stream.dataset === packageInputStream.data_stream.dataset)
    };
  }).filter(stream => Boolean(stream.packagePolicyInputStream)), [packageInputStreamShouldBeVisible, packageInputStreams, packagePolicyInput.streams]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-test-subj": "PackagePolicy.InputStreamConfig.Switch",
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 169,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 170,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 171,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement("h3", {
      "data-test-subj": "PackagePolicy.InputStreamConfig.title",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 172,
        columnNumber: 23
      }
    }, packageInput.title || packageInput.type)))),
    checked: packagePolicyInput.enabled,
    disabled: packagePolicyInput.keep_enabled,
    onChange: e => {
      const enabled = e.target.checked;
      updatePackagePolicyInput({
        enabled,
        streams: packagePolicyInput.streams.map(stream => ({
          ...stream,
          enabled
        }))
      });
      if (!enabled && isShowingStreams) {
        setIsShowingStreams(false);
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 13
    }
  }), showTopLevelDescription && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_reactMarkdown.default, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 17
    }
  }, String((_inputStreams$ = inputStreams[0]) === null || _inputStreams$ === void 0 ? void 0 : (_inputStreams$$packag = _inputStreams$.packageInputStream) === null || _inputStreams$$packag === void 0 ? void 0 : _inputStreams$$packag.description)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 13
    }
  }, hasErrors ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "danger",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.createPackagePolicy.stepConfigure.errorCountText",
    defaultMessage: "{count, plural, one {# error} other {# errors}}",
    values: {
      count: errorCount
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 21
    }
  }))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: hasErrors ? 'danger' : 'primary',
    onClick: () => setIsShowingStreams(!isShowingStreams),
    iconType: isShowingStreams ? 'arrowUp' : 'arrowDown',
    iconSide: "right",
    "aria-expanded": isShowingStreams,
    "aria-label": _i18n.i18n.translate('xpack.fleet.createPackagePolicy.stepConfigure.expandAriaLabel', {
      defaultMessage: 'Change default settings for {title}',
      values: {
        title: packageInput.title || packageInput.type
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.createPackagePolicy.stepConfigure.expandLabel",
    defaultMessage: "Change defaults",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 237,
      columnNumber: 21
    }
  })))))), isShowingStreams ? /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 29
    }
  }) : null, isShowingStreams && packageInput.vars && packageInput.vars.length ? /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_package_policy_input_config.PackagePolicyInputConfig, {
    "data-test-subj": "PackagePolicy.InputConfig",
    hasInputStreams: hasInputStreams,
    packageInputVars: packageInput.vars,
    packagePolicyInput: packagePolicyInput,
    updatePackagePolicyInput: updatePackagePolicyInput,
    inputValidationResults: inputValidationResults,
    forceShowErrors: forceShowErrors,
    isEditPage: isEditPage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 253,
      columnNumber: 13
    }
  }), hasInputStreams ? /*#__PURE__*/_react.default.createElement(ShortenedHorizontalRule, {
    margin: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 263,
      columnNumber: 32
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 263,
      columnNumber: 73
    }
  })) : null, isShowingStreams ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    "data-test-subj": "PackagePolicy.InputConfig.streams",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 269,
      columnNumber: 11
    }
  }, inputStreams.map(({
    packageInputStream,
    packagePolicyInputStream
  }, index) => {
    var _inputValidationResul, _inputValidationResul2;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: index,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 271,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_package_policy_input_stream.PackagePolicyInputStreamConfig, {
      "data-test-subj": "PackagePolicy.InputStreamConfig",
      packageInfo: packageInfo,
      packageInputStream: packageInputStream,
      totalStreams: inputStreams.length,
      packagePolicyInputStream: packagePolicyInputStream,
      updatePackagePolicyInputStream: updatedStream => {
        const indexOfUpdatedStream = packagePolicyInput.streams.findIndex(stream => stream.data_stream.dataset === packageInputStream.data_stream.dataset);
        const newStreams = [...packagePolicyInput.streams];
        newStreams[indexOfUpdatedStream] = {
          ...newStreams[indexOfUpdatedStream],
          ...updatedStream
        };
        const updatedInput = {
          streams: newStreams
        };

        // Update input enabled state if needed
        if (!packagePolicyInput.enabled && updatedStream.enabled) {
          updatedInput.enabled = true;
        } else if (packagePolicyInput.enabled && !newStreams.find(stream => stream.enabled)) {
          updatedInput.enabled = false;
        }
        updatePackagePolicyInput(updatedInput);
      },
      inputStreamValidationResults: (_inputValidationResul = inputValidationResults === null || inputValidationResults === void 0 ? void 0 : (_inputValidationResul2 = inputValidationResults.streams) === null || _inputValidationResul2 === void 0 ? void 0 : _inputValidationResul2[packagePolicyInputStream.data_stream.dataset]) !== null && _inputValidationResul !== void 0 ? _inputValidationResul : {},
      forceShowErrors: forceShowErrors,
      isEditPage: isEditPage,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 272,
        columnNumber: 17
      }
    }), index !== inputStreams.length - 1 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 317,
        columnNumber: 21
      }
    }), /*#__PURE__*/_react.default.createElement(ShortenedHorizontalRule, {
      margin: "none",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 318,
        columnNumber: 21
      }
    })) : null);
  })) : null);
});