"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SchedulePanel = exports.ConnectorScheduling = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _searchConnectors = require("@kbn/search-connectors");
var _connector_scheduling = require("@kbn/search-connectors/components/scheduling/connector_scheduling");
var _api = require("../../../../../../common/types/api");
var _encode_path_params = require("../../../../shared/encode_path_params");
var _kibana = require("../../../../shared/kibana");
var _licensing = require("../../../../shared/licensing");
var _unsaved_changes_prompt = require("../../../../shared/unsaved_changes_prompt");
var _update_connector_scheduling_api_logic = require("../../../api/connector/update_connector_scheduling_api_logic");
var _routes = require("../../../routes");
var _connector_detail = require("../../connector_detail/connector_detail");
var _connector_view_logic = require("../../connector_detail/connector_view_logic");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/enterprise_search_content/components/search_index/connector/connector_scheduling.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SchedulePanel = ({
  title,
  description,
  children
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 13
    }
  }, title))), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 13
    }
  }, description)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 11
    }
  }), children)));
};
exports.SchedulePanel = SchedulePanel;
const ConnectorScheduling = () => {
  const {
    productFeatures,
    navigateToUrl
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const {
    connector,
    hasDocumentLevelSecurityFeature,
    hasIncrementalSyncFeature
  } = (0, _kea.useValues)(_connector_view_logic.ConnectorViewLogic);
  const {
    status
  } = (0, _kea.useValues)(_update_connector_scheduling_api_logic.UpdateConnectorSchedulingApiLogic);
  const {
    makeRequest
  } = (0, _kea.useActions)(_update_connector_scheduling_api_logic.UpdateConnectorSchedulingApiLogic);
  const [hasChanges, setHasChanges] = (0, _react.useState)(false);
  const {
    hasPlatinumLicense
  } = (0, _kea.useValues)(_licensing.LicensingLogic);
  const shouldShowIncrementalSync = hasIncrementalSyncFeature && productFeatures.hasIncrementalSyncEnabled;
  const shouldShowAccessControlSync = hasDocumentLevelSecurityFeature && productFeatures.hasDocumentLevelSecurityEnabled;
  if (!connector) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_unsaved_changes_prompt.UnsavedChangesPrompt, {
    hasUnsavedChanges: hasChanges,
    messageText: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.connectorScheduling.unsaved.title', {
      defaultMessage: 'You have not saved your changes, are you sure you want to leave?'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_connector_scheduling.ConnectorSchedulingComponent, {
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.content.indices.connectorScheduling.page.description",
      defaultMessage: "Your connector is now deployed. Schedule recurring content and access control syncs here. If you want to run a quick test, launch a one-time sync using the {sync} button.",
      values: {
        sync: /*#__PURE__*/_react.default.createElement("b", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 101,
            columnNumber: 23
          }
        }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.connectorScheduling.page.sync.label', {
          defaultMessage: 'Sync'
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 17
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 13
      }
    })),
    connector: connector,
    configurationPathOnClick: () => navigateToUrl((0, _encode_path_params.generateEncodedPath)(_routes.CONNECTOR_DETAIL_TAB_PATH, {
      connectorId: connector.id,
      tabId: _connector_detail.ConnectorDetailTabId.CONFIGURATION
    })),
    dataTelemetryIdPrefix: "entSearchContent",
    hasChanges: hasChanges,
    hasIngestionError: connector.status === _searchConnectors.ConnectorStatus.ERROR,
    hasPlatinumLicense: hasPlatinumLicense,
    setHasChanges: setHasChanges,
    shouldShowAccessControlSync: shouldShowAccessControlSync,
    shouldShowIncrementalSync: shouldShowIncrementalSync,
    updateConnectorStatus: status === _api.Status.LOADING,
    updateScheduling: scheduling => makeRequest({
      connectorId: connector.id,
      scheduling
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 7
    }
  }));
};
exports.ConnectorScheduling = ConnectorScheduling;