"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WaitingForConnectorStep = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/enterprise_search_content/components/connector_detail/components/waiting_for_connector_step.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const WaitingForConnectorStep = ({
  recheck,
  isLoading,
  isRecheckDisabled,
  showFinishLaterButton = false
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.connector_detail.configurationConnector.steps.waitingForConnector.callout.title', {
      defaultMessage: 'Waiting for your connector'
    }),
    iconType: "info",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.connector_detail.configurationConnector.steps.waitingForConnector.callout.description', {
    defaultMessage: 'Your connector has not connected to Search. Troubleshoot your configuration and refresh the page.'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "warning",
    fill: true,
    disabled: isRecheckDisabled,
    "data-test-subj": "entSearchContent-connector-waitingForConnector-callout-recheckNow",
    "data-telemetry-id": "entSearchContent-connector-waitingForConnector-callout-recheckNow",
    iconType: "refresh",
    onClick: recheck,
    isLoading: isLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.connector_detail.configurationConnector.steps.waitingForConnector.callout.button.label', {
    defaultMessage: 'Recheck now'
  }))), showFinishLaterButton && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "warning",
    "data-test-subj": "entSearchContent-connector-waitingForConnector-callout-finishLaterButton",
    "data-telemetry-id": "entSearchContent-connector-waitingForConnector-callout-finishLaterButton",
    iconType: "save",
    onClick: () => {},
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.connector_detail.configurationConnector.steps.waitingForConnector.callout.finishLaterButton.label', {
    defaultMessage: 'Finish deployment later'
  }))))));
};
exports.WaitingForConnectorStep = WaitingForConnectorStep;