"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchApplicationsList = exports.CreateSearchApplicationButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _useThrottle = _interopRequireDefault(require("react-use/lib/useThrottle"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../common/constants");
var _timers = require("../../../shared/constants/timers");
var _doc_links = require("../../../shared/doc_links");
var _kibana = require("../../../shared/kibana");
var _licensing = require("../../../shared/licensing");
var _licensing_callout = require("../../../shared/licensing_callout/licensing_callout");
var _routes = require("../../routes");
var _page_template = require("../layout/page_template");
var _empty_search_applications_prompt = require("./components/empty_search_applications_prompt");
var _search_applications_table = require("./components/tables/search_applications_table");
var _create_search_application_flyout = require("./create_search_application_flyout");
var _delete_search_application_modal = require("./delete_search_application_modal");
var _search_application_indices_flyout = require("./search_application_indices_flyout");
var _search_application_indices_flyout_logic = require("./search_application_indices_flyout_logic");
var _search_applications_list_logic = require("./search_applications_list_logic");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/applications/components/search_applications/search_applications_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CreateSearchApplicationButton = ({
  disabled
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "center",
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "beaker",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.searchApplications.list.createSearchApplicationTechnicalPreviewPopover.title",
      defaultMessage: "Beta",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 13
      }
    }))),
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      "data-test-subj": "create-search-application-button-popover-content",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.searchApplications.list.createSearchApplicationTechnicalPreviewPopover.body",
      defaultMessage: "This functionality may be changed or removed completely in a future release.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 11
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    iconType: "plusInCircle",
    "data-test-subj": "enterprise-search-search-applications-creation-button",
    "data-telemetry-id": "entSearchApplications-list-createSearchApplication",
    isDisabled: disabled,
    onClick: () => _kibana.KibanaLogic.values.navigateToUrl(_routes.SEARCH_APPLICATION_CREATION_PATH),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.list.createSearchApplicationButton.label', {
    defaultMessage: 'Create'
  })));
};
exports.CreateSearchApplicationButton = CreateSearchApplicationButton;
const SearchApplicationsList = ({
  createSearchApplicationFlyoutOpen
}) => {
  var _results$length;
  const {
    closeDeleteSearchApplicationModal,
    fetchSearchApplications,
    onPaginate,
    openDeleteSearchApplicationModal,
    setSearchQuery,
    setIsFirstRequest
  } = (0, _kea.useActions)(_search_applications_list_logic.SearchApplicationsListLogic);
  const {
    openFlyout: openViewIndicesFlyout
  } = (0, _kea.useActions)(_search_application_indices_flyout_logic.SearchApplicationIndicesFlyoutLogic);
  const {
    isCloud,
    navigateToUrl
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const {
    hasPlatinumLicense
  } = (0, _kea.useValues)(_licensing.LicensingLogic);
  const isGated = !isCloud && !hasPlatinumLicense;
  const {
    deleteModalSearchApplicationName,
    hasNoSearchApplications,
    isDeleteModalVisible,
    isLoading,
    meta,
    results,
    searchQuery
  } = (0, _kea.useValues)(_search_applications_list_logic.SearchApplicationsListLogic);
  const throttledSearchQuery = (0, _useThrottle.default)(searchQuery, _timers.INPUT_THROTTLE_DELAY_MS);
  (0, _react.useEffect)(() => {
    // Don't fetch search applications if we don't have a valid license
    if (!isGated) {
      fetchSearchApplications();
    }
  }, [meta.from, meta.size, throttledSearchQuery]);
  (0, _react.useEffect)(() => {
    // We don't want to trigger loading for each search query change, so we need this
    // flag to set if the call to backend is first request.
    if (!isGated) {
      setIsFirstRequest();
    }
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isDeleteModalVisible ? /*#__PURE__*/_react.default.createElement(_delete_search_application_modal.DeleteSearchApplicationModal, {
    searchApplicationName: deleteModalSearchApplicationName,
    onClose: closeDeleteSearchApplicationModal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 9
    }
  }) : null, /*#__PURE__*/_react.default.createElement(_search_application_indices_flyout.SearchApplicationIndicesFlyout, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 7
    }
  }), createSearchApplicationFlyoutOpen && /*#__PURE__*/_react.default.createElement(_create_search_application_flyout.CreateSearchApplication, {
    onClose: () => navigateToUrl(_routes.SEARCH_APPLICATIONS_PATH),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_page_template.EnterpriseSearchApplicationsPageTemplate, {
    pageChrome: [],
    pageHeader: {
      description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.enterpriseSearch.searchApplications.list.description",
        defaultMessage: "Search applications help make your Elasticsearch data easily searchable for end users. Create, build, and manage all your search applications here. To learn more, {documentationUrl}.",
        values: {
          documentationUrl: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            "data-test-subj": "search-applications-documentation-link",
            href: _doc_links.docLinks.searchApplications,
            target: "_blank",
            "data-telemetry-id": "entSearchApplications-documentation-viewDocumentaion",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 171,
              columnNumber: 19
            }
          }, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.list.documentation', {
            defaultMessage: 'explore our search applications documentation'
          }))
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 166,
          columnNumber: 13
        }
      }),
      pageTitle: _constants.SEARCH_APPS_TITLE,
      rightSideItems: isLoading ? [] : !hasNoSearchApplications ? [/*#__PURE__*/_react.default.createElement(CreateSearchApplicationButton, {
        disabled: isGated,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 192,
          columnNumber: 16
        }
      })] : []
    },
    pageViewTelemetry: "Search Applications",
    isLoading: isLoading && !isGated,
    "data-test-subj": "searchApplicationsListPage",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 7
    }
  }, isGated && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_licensing_callout.LicensingCallout, {
    feature: _licensing_callout.LICENSING_FEATURE.SEARCH_APPLICATIONS,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 13
    }
  })), !hasNoSearchApplications && !isGated ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    "data-test-subj": "enterpriseSearchSearchApplicationsListFieldSearch",
    value: searchQuery,
    placeholder: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.list.searchBar.placeholder', {
      defaultMessage: 'Search applications'
    }),
    "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.list.searchBar.ariaLabel', {
      defaultMessage: 'Search applications'
    }),
    fullWidth: true,
    onChange: event => {
      setSearchQuery(event.currentTarget.value);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.list.searchBar.description', {
    defaultMessage: 'Locate a search application via name.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.searchApplications.list.itemRange",
    defaultMessage: "Showing {from}-{to} of {total}",
    values: {
      from: /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 246,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedNumber, {
        value: meta.from + 1,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 247,
          columnNumber: 23
        }
      })),
      to: /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 251,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedNumber, {
        value: meta.from + ((_results$length = results === null || results === void 0 ? void 0 : results.length) !== null && _results$length !== void 0 ? _results$length : 0),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 252,
          columnNumber: 23
        }
      })),
      total: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedNumber, {
        value: meta.total,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 255,
          columnNumber: 26
        }
      })
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_search_applications_table.SearchApplicationsListTable, {
    searchApplications: results,
    meta: meta,
    onChange: onPaginate,
    onDelete: openDeleteSearchApplicationModal,
    viewSearchApplicationIndices: openViewIndicesFlyout,
    loading: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 260,
      columnNumber: 13
    }
  })) : /*#__PURE__*/_react.default.createElement(_empty_search_applications_prompt.EmptySearchApplicationsPrompt, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 270,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(CreateSearchApplicationButton, {
    disabled: isGated,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 271,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 275,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 276,
      columnNumber: 9
    }
  })));
};
exports.SearchApplicationsList = SearchApplicationsList;