"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecurityUserName = exports.SecurityUserAvatar = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _userProfileComponents = require("@kbn/user-profile-components");
var _use_user_profile = require("./use_user_profile");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/elastic_assistant/public/src/components/get_comments/user_avatar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SecurityUserAvatar = ({
  user
}) => {
  const {
    data: userProfile
  } = (0, _use_user_profile.useUserProfile)({
    user
  });
  if (userProfile) {
    return /*#__PURE__*/_react.default.createElement(_userProfileComponents.UserAvatar, {
      "data-test-subj": "userAvatar",
      user: userProfile.user,
      avatar: userProfile.avatar,
      size: "l",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 24,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
    "data-test-subj": "genericAvatar",
    name: "user",
    size: "l",
    color: "subdued",
    iconType: "userAvatar",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 5
    }
  });
};
exports.SecurityUserAvatar = SecurityUserAvatar;
const SecurityUserName = ({
  user
}) => {
  var _ref, _user$name;
  const {
    data: userProfile
  } = (0, _use_user_profile.useUserProfile)({
    user
  });
  if (userProfile) {
    var _userProfile$user$ful;
    return (_userProfile$user$ful = userProfile.user.full_name) !== null && _userProfile$user$ful !== void 0 ? _userProfile$user$ful : userProfile.user.username;
  }
  return (_ref = (_user$name = user === null || user === void 0 ? void 0 : user.name) !== null && _user$name !== void 0 ? _user$name : user === null || user === void 0 ? void 0 : user.id) !== null && _ref !== void 0 ? _ref : i18n.YOU;
};
exports.SecurityUserName = SecurityUserName;