"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.COPY_TO_CLIPBOARD = exports.BaseCommentActions = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/elastic_assistant/public/src/components/comment_actions/base_comment_actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const COPY_TO_CLIPBOARD = exports.COPY_TO_CLIPBOARD = _i18n.i18n.translate('xpack.elasticAssistantPlugin.assistant.commentActions.copyToClipboard', {
  defaultMessage: 'Copy to clipboard'
});
/**
 * Returns the content of the message compatible with a standard markdown renderer.
 *
 * Content references are removed as they can only be rendered by the assistant.
 */
function getSelfContainedContent(content) {
  return (0, _elasticAssistantCommon.removeContentReferences)(content).trim();
}
const BaseCommentActionsComponent = ({
  message,
  children
}) => {
  var _message$content;
  const content = (_message$content = message.content) !== null && _message$content !== void 0 ? _message$content : '';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 5
    }
  }, children, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "copy-to-clipboard-action",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: COPY_TO_CLIPBOARD,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: getSelfContainedContent(content),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 11
    }
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": COPY_TO_CLIPBOARD,
    color: "primary",
    iconType: "copyClipboard",
    onClick: copy,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 15
    }
  })))));
};
const BaseCommentActions = exports.BaseCommentActions = /*#__PURE__*/_react.default.memo(BaseCommentActionsComponent);