"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getShareAppMenuItem = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _discoverUtils = require("@kbn/discover-utils");
var _lodash = require("lodash");
var _public = require("@kbn/kibana-utils-plugin/public");
var _i18n = require("@kbn/i18n");
var _get_sharing_data = require("../../../../../utils/get_sharing_data");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/discover/public/application/main/components/top_nav/app_menu_actions/get_share.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const getShareAppMenuItem = ({
  discoverParams,
  services,
  stateContainer,
  hasIntegrations,
  hasUnsavedChanges,
  currentTab,
  persistedDiscoverSession
}) => {
  if (!services.share) {
    return [];
  }
  const shareExecutor = async ({
    anchorElement,
    asExport
  }) => {
    var _services$share;
    const {
      dataView,
      isEsqlMode
    } = discoverParams;
    const searchSourceSharingData = await (0, _get_sharing_data.getSharingData)(stateContainer.savedSearchState.getState().searchSource, stateContainer.appState.getState(), services, isEsqlMode);
    const {
      locator,
      discoverFeatureFlags
    } = services;
    const appState = stateContainer.appState.getState();
    const {
      timefilter
    } = services.data.query.timefilter;
    const timeRange = timefilter.getTime();
    const refreshInterval = timefilter.getRefreshInterval();
    const filters = services.filterManager.getFilters();

    // Share -> Get links -> Snapshot
    const params = {
      ...(0, _lodash.omit)(appState, 'dataSource'),
      ...(persistedDiscoverSession !== null && persistedDiscoverSession !== void 0 && persistedDiscoverSession.id ? {
        savedSearchId: persistedDiscoverSession.id
      } : {}),
      ...(dataView !== null && dataView !== void 0 && dataView.isPersisted() ? {
        dataViewId: dataView === null || dataView === void 0 ? void 0 : dataView.id
      } : {
        dataViewSpec: dataView === null || dataView === void 0 ? void 0 : dataView.toMinimalSpec()
      }),
      filters,
      timeRange,
      refreshInterval
    };
    const tabsEnabled = discoverFeatureFlags.getTabsEnabled();
    if (tabsEnabled && currentTab) {
      params.tab = {
        id: currentTab.id,
        label: currentTab.label
      };
    }
    const relativeUrl = locator.getRedirectUrl(params);

    // This logic is duplicated from `relativeToAbsolute` (for bundle size reasons). Ultimately, this should be
    // replaced when https://github.com/elastic/kibana/issues/153323 is implemented.
    const link = document.createElement('a');
    link.setAttribute('href', relativeUrl);
    const shareableUrl = link.href;

    // Share -> Get links -> Saved object
    let shareableUrlForSavedObject = await locator.getUrl({
      savedSearchId: persistedDiscoverSession === null || persistedDiscoverSession === void 0 ? void 0 : persistedDiscoverSession.id
    }, {
      absolute: true
    });

    // UrlPanelContent forces a '_g' parameter in the saved object URL:
    // https://github.com/elastic/kibana/blob/a30508153c1467b1968fb94faf1debc5407f61ea/src/plugins/share/public/components/url_panel_content.tsx#L230
    // Since our locator doesn't add the '_g' parameter if it's not needed, UrlPanelContent
    // will interpret it as undefined and add '?_g=' to the URL, which is invalid in Discover,
    // so instead we add an empty object for the '_g' parameter to the URL.
    shareableUrlForSavedObject = (0, _public.setStateToKbnUrl)('_g', {}, undefined, shareableUrlForSavedObject);
    (_services$share = services.share) === null || _services$share === void 0 ? void 0 : _services$share.toggleShareContextMenu({
      asExport,
      anchorElement,
      allowShortUrl: !!services.capabilities.discover_v2.createShortUrl,
      shareableUrl,
      shareableUrlForSavedObject,
      shareableUrlLocatorParams: {
        locator,
        params
      },
      objectId: persistedDiscoverSession === null || persistedDiscoverSession === void 0 ? void 0 : persistedDiscoverSession.id,
      objectType: 'search',
      objectTypeAlias: _i18n.i18n.translate('discover.share.objectTypeAlias', {
        defaultMessage: 'Discover session'
      }),
      objectTypeMeta: {
        title: _i18n.i18n.translate('discover.share.shareModal.title', {
          defaultMessage: 'Share this Discover session'
        }),
        config: {
          embed: {
            disabled: true,
            showPublicUrlSwitch: _get_sharing_data.showPublicUrlSwitch
          },
          integration: {
            export: {
              csvReports: {
                draftModeCallOut: /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
                  color: "warning",
                  iconType: "warning",
                  title: _i18n.i18n.translate('discover.exports.csvReports.warning.title', {
                    defaultMessage: 'Unsaved changes'
                  }),
                  __self: void 0,
                  __source: {
                    fileName: _jsxFileName,
                    lineNumber: 136,
                    columnNumber: 19
                  }
                }, _i18n.i18n.translate('discover.exports.csvReports.postURLWatcherMessage.unsavedChanges', {
                  defaultMessage: 'URL may change if you upgrade Kibana.'
                }))
              }
            }
          }
        }
      },
      sharingData: {
        isTextBased: isEsqlMode,
        locatorParams: [{
          id: locator.id,
          params
        }],
        ...searchSourceSharingData,
        // CSV reports can be generated without a saved search so we provide a fallback title
        title: (persistedDiscoverSession === null || persistedDiscoverSession === void 0 ? void 0 : persistedDiscoverSession.title) || _i18n.i18n.translate('discover.localMenu.fallbackReportTitle', {
          defaultMessage: 'Untitled Discover session'
        })
      },
      isDirty: !(persistedDiscoverSession !== null && persistedDiscoverSession !== void 0 && persistedDiscoverSession.id) || hasUnsavedChanges,
      onClose: () => {
        anchorElement === null || anchorElement === void 0 ? void 0 : anchorElement.focus();
      }
    });
  };
  const menuItems = [{
    id: _discoverUtils.AppMenuActionId.share,
    type: _discoverUtils.AppMenuActionType.primary,
    controlProps: {
      label: _i18n.i18n.translate('discover.localMenu.shareTitle', {
        defaultMessage: 'Share'
      }),
      description: _i18n.i18n.translate('discover.localMenu.shareSearchDescription', {
        defaultMessage: 'Share Discover session'
      }),
      iconType: 'share',
      testId: 'shareTopNavButton',
      onClick: ({
        anchorElement
      }) => shareExecutor({
        anchorElement
      })
    }
  }];
  if (hasIntegrations) {
    menuItems.unshift({
      id: _discoverUtils.AppMenuActionId.export,
      type: _discoverUtils.AppMenuActionType.primary,
      controlProps: {
        label: _i18n.i18n.translate('discover.localMenu.exportTitle', {
          defaultMessage: 'Export'
        }),
        description: _i18n.i18n.translate('discover.localMenu.shareSearchDescription', {
          defaultMessage: 'Export Discover session'
        }),
        iconType: 'download',
        testId: 'exportTopNavButton',
        onClick: ({
          anchorElement
        }) => shareExecutor({
          anchorElement,
          asExport: true
        })
      }
    });
  }
  return menuItems;
};
exports.getShareAppMenuItem = getShareAppMenuItem;