"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IncreaseFieldMappingLimit = IncreaseFieldMappingLimit;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _translations = require("../../../../../../../common/translations");
var _hooks = require("../../../../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/dataset_quality/public/components/dataset_quality_details/quality_issue_flyout/degraded_field/possible_mitigations/field_limit/increase_field_mapping_limit.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function IncreaseFieldMappingLimit({
  totalFieldLimit
}) {
  // Propose the user a 30% increase over the current limit
  const proposedNewLimit = Math.round(totalFieldLimit * 1.3);
  const [newFieldLimit, setNewFieldLimit] = (0, _react.useState)(proposedNewLimit);
  const [isInvalid, setIsInvalid] = (0, _react.useState)(false);
  const {
    updateNewFieldLimit,
    isMitigationInProgress
  } = (0, _hooks.useQualityIssues)();
  const validateNewLimit = newLimit => {
    const parsedLimit = parseInt(newLimit, 10);
    setNewFieldLimit(parsedLimit);
    if (totalFieldLimit > parsedLimit) {
      setIsInvalid(true);
    } else {
      setIsInvalid(false);
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    "data-test-subj": "datasetQualityDetailsDegradedFieldFlyoutIncreaseFieldLimitPanel",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _translations.fieldLimitMitigationCurrentLimitLabelText,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "datasetQualityIncreaseFieldMappingCurrentLimitFieldText",
    disabled: true,
    value: totalFieldLimit,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _translations.fieldLimitMitigationNewLimitButtonText,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    "data-test-subj": "datasetQualityIncreaseFieldMappingProposedLimitFieldText",
    placeholder: _translations.fieldLimitMitigationNewLimitPlaceholderText,
    value: newFieldLimit,
    onChange: e => validateNewLimit(e.target.value),
    "aria-label": _translations.fieldLimitMitigationNewLimitPlaceholderText,
    isInvalid: isInvalid,
    min: totalFieldLimit + 1,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    hasEmptyLabelSpace: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "datasetQualityIncreaseFieldMappingLimitButton",
    disabled: isInvalid,
    onClick: () => updateNewFieldLimit(newFieldLimit),
    isLoading: isMitigationInProgress,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 11
    }
  }, _translations.fieldLimitMitigationApplyButtonText))));
}