"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TestScript = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _esQuery = require("@kbn/es-query");
var _public = require("@kbn/data-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_management/public/components/field_editor/components/scripting_help/test_script.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class TestScript extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "defaultProps", {
      name: 'myScriptedField'
    });
    (0, _defineProperty2.default)(this, "state", {
      isLoading: false,
      additionalFields: [],
      previewData: undefined
    });
    (0, _defineProperty2.default)(this, "previewScript", async searchContext => {
      var _scriptResponse$hits;
      const {
        indexPattern,
        name,
        script,
        executeScript
      } = this.props;
      if (!script || script.length === 0) {
        return;
      }
      this.setState({
        isLoading: true
      });
      let query;
      if (searchContext) {
        const esQueryConfigs = (0, _public.getEsQueryConfig)(this.context.services.uiSettings);
        query = (0, _esQuery.buildEsQuery)(this.props.indexPattern, searchContext.query || [], [], esQueryConfigs);
      }
      const scriptResponse = await executeScript({
        name: name,
        script,
        indexPatternTitle: indexPattern.title,
        query,
        additionalFields: this.state.additionalFields.map(option => option.value),
        http: this.context.services.http
      });
      if (scriptResponse.status !== 200) {
        this.setState({
          isLoading: false,
          previewData: scriptResponse
        });
        return;
      }
      this.setState({
        isLoading: false,
        previewData: (_scriptResponse$hits = scriptResponse.hits) === null || _scriptResponse$hits === void 0 ? void 0 : _scriptResponse$hits.hits.map(hit => ({
          _id: hit._id,
          ...hit._source,
          ...hit.fields
        }))
      });
    });
    (0, _defineProperty2.default)(this, "onAdditionalFieldsChange", selectedOptions => {
      this.setState({
        additionalFields: selectedOptions
      });
    });
  }
  componentDidMount() {
    if (this.props.script) {
      this.previewScript();
    }
  }
  renderPreview(previewData) {
    if (!previewData) {
      return null;
    }
    if (previewData.error) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        title: _i18n.i18n.translate('indexPatternManagement.testScript.errorMessage', {
          defaultMessage: `There's an error in your script`
        }),
        color: "danger",
        iconType: "cross",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 131,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        language: "json",
        className: "scriptPreviewCodeBlock",
        "data-test-subj": "scriptedFieldPreview",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 138,
          columnNumber: 11
        }
      }, JSON.stringify(previewData.error, null, ' ')));
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 150,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 151,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "indexPatternManagement.testScript.resultsLabel",
      defaultMessage: "First 10 results",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 153,
        columnNumber: 13
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 159,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: "json",
      className: "scriptPreviewCodeBlock",
      "data-test-subj": "scriptedFieldPreview",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 160,
        columnNumber: 9
      }
    }, JSON.stringify(previewData, null, ' ')));
  }
  renderToolbar() {
    const fieldsByTypeMap = new Map();
    const fields = [];
    this.props.indexPattern.fields.getAll().filter(field => {
      const isMultiField = field.isSubtypeMulti();
      return !field.name.startsWith('_') && !isMultiField && !field.scripted;
    }).forEach(field => {
      if (fieldsByTypeMap.has(field.type)) {
        const fieldsList = fieldsByTypeMap.get(field.type);
        fieldsList.push(field.name);
        fieldsByTypeMap.set(field.type, fieldsList);
      } else {
        fieldsByTypeMap.set(field.type, [field.name]);
      }
    });
    fieldsByTypeMap.forEach((fieldsList, fieldType) => {
      fields.push({
        label: fieldType,
        options: fieldsList.sort().map(fieldName => {
          return {
            value: fieldName,
            label: fieldName
          };
        })
      });
    });
    fields.sort((a, b) => {
      if (a.label < b.label) return -1;
      if (a.label > b.label) return 1;
      return 0;
    });
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 207,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('indexPatternManagement.testScript.fieldsLabel', {
        defaultMessage: 'Additional fields'
      }),
      fullWidth: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 208,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      placeholder: _i18n.i18n.translate('indexPatternManagement.testScript.fieldsPlaceholder', {
        defaultMessage: 'Select...'
      }),
      options: fields,
      selectedOptions: this.state.additionalFields,
      onChange: selected => this.onAdditionalFieldsChange(selected),
      "data-test-subj": "additionalFieldsSelect",
      fullWidth: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 214,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 226,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement("div", {
      className: "testScript__searchBar",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 228,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(this.context.services.unifiedSearch.ui.SearchBar, {
      displayStyle: "inPage",
      appName: 'indexPatternManagement',
      showFilterBar: false,
      showDatePicker: false,
      showQueryInput: true,
      query: this.context.services.data.query.queryString.getDefaultQuery(),
      onQuerySubmit: this.previewScript,
      indexPatterns: [this.props.indexPattern],
      customSubmitButton: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        disabled: this.props.script ? false : true,
        isLoading: this.state.isLoading,
        "data-test-subj": "runScriptButton",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 239,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternManagement.testScript.submitButtonLabel",
        defaultMessage: "Run script",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 244,
          columnNumber: 17
        }
      })),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 229,
        columnNumber: 11
      }
    })));
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 258,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 259,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 260,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("h3", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 261,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "indexPatternManagement.testScript.resultsTitle",
      defaultMessage: "Preview results",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 262,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 267,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "indexPatternManagement.testScript.instructions",
      defaultMessage: "Run your script to preview the first 10 results. You can also select some additional fields to include in your results to gain more context or add a query to filter on specific documents.",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 268,
        columnNumber: 13
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 276,
        columnNumber: 9
      }
    }), this.renderToolbar(), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 278,
        columnNumber: 9
      }
    }), this.renderPreview(this.state.previewData));
  }
}
exports.TestScript = TestScript;
(0, _defineProperty2.default)(TestScript, "contextType", _public2.context);