"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.openEditControlGroupFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _presentationUtil = require("@kbn/presentation-util");
var _kibana_services = require("../services/kibana_services");
var _confirm_delete_control = require("../common/confirm_delete_control");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/controls/public/control_group/open_edit_control_group_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const openEditControlGroupFlyout = (controlGroupApi, stateManager) => {
  const lastSavedState = stateManager.getLatestState();
  (0, _presentationUtil.openLazyFlyout)({
    core: _kibana_services.coreServices,
    parentApi: controlGroupApi.parentApi,
    loadContent: async ({
      closeFlyout
    }) => {
      const {
        ControlGroupEditor
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./components/control_group_editor')));
      return /*#__PURE__*/_react.default.createElement(ControlGroupEditor, {
        api: controlGroupApi,
        stateManager: stateManager,
        onSave: closeFlyout,
        onDeleteAll: () => {
          (0, _confirm_delete_control.confirmDeleteAllControls)().then(confirmed => {
            if (confirmed) Object.keys(controlGroupApi.children$.getValue()).forEach(childId => {
              controlGroupApi.removePanel(childId);
            });
            closeFlyout();
          });
        },
        onCancel: () => {
          stateManager.reinitializeState(lastSavedState);
          closeFlyout();
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 31,
          columnNumber: 9
        }
      });
    },
    flyoutProps: {
      'aria-label': _i18n.i18n.translate('controls.controlGroup.manageControl', {
        defaultMessage: 'Edit control settings'
      }),
      outsideClickCloses: false,
      triggerId: 'dashboardAddTopNavButton'
    }
  });
};
exports.openEditControlGroupFlyout = openEditControlGroupFlyout;