"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.letBrowserHandleEvent = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Helper functions for determining which events we should
 * let browsers handle natively, e.g. new tabs/windows
 */

const letBrowserHandleEvent = event => event.defaultPrevented || isModifiedEvent(event) || !isLeftClickEvent(event) || isTargetBlank(event);
exports.letBrowserHandleEvent = letBrowserHandleEvent;
const isModifiedEvent = event => !!(event.metaKey || event.altKey || event.ctrlKey || event.shiftKey);
const isLeftClickEvent = event => event.button === 0;
const isTargetBlank = event => {
  const element = event.target;
  const target = element.getAttribute('target');
  return !!target && target !== '_self';
};