"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserActions = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _add_comment = require("../add_comment");
var _navigation = require("../../common/navigation");
var _helpers = require("./helpers");
var _use_user_actions_handler = require("./use_user_actions_handler");
var _constants = require("./constants");
var _user_tooltip = require("../user_profiles/user_tooltip");
var _username = require("../user_profiles/username");
var _hoverable_avatar = require("../user_profiles/hoverable_avatar");
var _user_actions_list = require("./user_actions_list");
var _use_user_actions_pagination = require("./use_user_actions_pagination");
var _use_user_actions_last_page = require("./use_user_actions_last_page");
var _show_more_button = require("./show_more_button");
var _use_last_page = require("./use_last_page");
var _use_user_permissions = require("./use_user_permissions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/user_actions/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getIconsCss = (hasNextPage, euiTheme) => {
  const customSize = hasNextPage ? {
    showMoreSectionSize: euiTheme.size.xxxl,
    marginTopShowMoreSectionSize: euiTheme.size.xxxl,
    marginBottomShowMoreSectionSize: euiTheme.size.xxxl
  } : {
    showMoreSectionSize: euiTheme.size.m,
    marginTopShowMoreSectionSize: euiTheme.size.m,
    marginBottomShowMoreSectionSize: euiTheme.size.m
  };
  const blockSize = `${customSize.showMoreSectionSize} + ${customSize.marginTopShowMoreSectionSize} +
  ${customSize.marginBottomShowMoreSectionSize}`;
  return `
          .commentList--hasShowMore
            [class*='euiTimelineItem-center']:last-child:not(:only-child)
            > [class*='euiTimelineItemIcon-']::before {
            block-size: calc(
              100% + ${blockSize}
            );
          }
          .commentList--hasShowMore
            [class*='euiTimelineItem-center']:first-child
            > [class*='euiTimelineItemIcon-']::before {
            inset-block-start: 0%;
            block-size: calc(
              100% + ${blockSize}
            );
          }
          .commentList--hasShowMore
              [class*='euiTimelineItem-']
              > [class*='euiTimelineItemIcon-']::before {
              block-size: calc(
                100% + ${blockSize}
              );
              }
        `;
};
const UserActions = exports.UserActions = /*#__PURE__*/_react.default.memo(props => {
  const {
    currentUserProfile,
    data: caseData,
    statusActionButton,
    useFetchAlertData,
    userActivityQueryParams,
    userActionsStats
  } = props;
  const {
    detailName: caseId
  } = (0, _navigation.useCaseViewParams)();
  const {
    lastPage
  } = (0, _use_last_page.useLastPage)({
    userActivityQueryParams,
    userActionsStats
  });
  const {
    infiniteCaseUserActions,
    infiniteLatestAttachments,
    isLoadingInfiniteUserActions,
    hasNextPage,
    fetchNextPage,
    showBottomList,
    isFetchingNextPage
  } = (0, _use_user_actions_pagination.useUserActionsPagination)({
    userActivityQueryParams,
    caseId: caseData.id,
    lastPage
  });
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    isLoadingLastPageUserActions,
    lastPageUserActions,
    lastPageAttachments
  } = (0, _use_user_actions_last_page.useLastPageUserActions)({
    userActivityQueryParams,
    caseId: caseData.id,
    lastPage
  });
  const alertIdsWithoutRuleInfo = (0, _react.useMemo)(() => (0, _helpers.getManualAlertIdsWithNoRuleId)(caseData.comments), [caseData.comments]);
  const [loadingAlertData, manualAlertsData] = useFetchAlertData(alertIdsWithoutRuleInfo);
  const {
    getCanAddUserComments
  } = (0, _use_user_permissions.useUserPermissions)();

  // add-comment markdown is not visible in History filter
  const shouldShowCommentEditor = getCanAddUserComments(userActivityQueryParams);
  const {
    commentRefs,
    handleManageMarkdownEditId,
    handleManageQuote,
    handleUpdate,
    loadingCommentIds
  } = (0, _use_user_actions_handler.useUserActionsHandler)();
  const MarkdownNewComment = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_add_comment.AddComment, {
    id: _constants.NEW_COMMENT_ID,
    caseId: caseId,
    ref: element => commentRefs.current[_constants.NEW_COMMENT_ID] = element,
    onCommentPosted: handleUpdate,
    onCommentSaving: handleManageMarkdownEditId.bind(null, _constants.NEW_COMMENT_ID),
    showLoading: false,
    statusActionButton: statusActionButton,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 7
    }
  }), [caseId, handleUpdate, handleManageMarkdownEditId, statusActionButton, commentRefs]);
  const bottomActions = shouldShowCommentEditor ? [{
    username: /*#__PURE__*/_react.default.createElement(_user_tooltip.UserToolTip, {
      userInfo: currentUserProfile,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_username.Username, {
      userInfo: currentUserProfile,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 146,
        columnNumber: 15
      }
    })),
    'data-test-subj': 'add-comment',
    timelineAvatar: /*#__PURE__*/_react.default.createElement(_hoverable_avatar.HoverableAvatar, {
      userInfo: currentUserProfile,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 150,
        columnNumber: 27
      }
    }),
    className: 'isEdit',
    children: MarkdownNewComment
  }] : [];
  const handleShowMore = (0, _react.useCallback)(() => {
    if (fetchNextPage) {
      fetchNextPage();
    }
  }, [fetchNextPage]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 8,
    "data-test-subj": "user-actions-loading",
    isLoading: isLoadingLastPageUserActions || loadingCommentIds.includes(_constants.NEW_COMMENT_ID) || isLoadingInfiniteUserActions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, (0, _extends2.default)({}, showBottomList ? {
    css: (0, _react2.css)`
                ${getIconsCss(hasNextPage, euiTheme)}
              `
  } : {}, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_user_actions_list.UserActionsList, (0, _extends2.default)({}, props, {
    caseUserActions: infiniteCaseUserActions,
    attachments: infiniteLatestAttachments,
    loadingAlertData: loadingAlertData,
    manualAlertsData: manualAlertsData,
    commentRefs: commentRefs,
    handleManageQuote: handleManageQuote,
    bottomActions: lastPage <= 1 ? bottomActions : [],
    isExpandable: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 9
    }
  })), hasNextPage && /*#__PURE__*/_react.default.createElement(_show_more_button.ShowMoreButton, {
    onShowMoreClick: handleShowMore,
    isLoading: isFetchingNextPage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 11
    }
  }), lastPageUserActions !== null && lastPageUserActions !== void 0 && lastPageUserActions.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, (0, _extends2.default)({}, !hasNextPage ? {
    css: (0, _react2.css)`
                    margin-top: ${euiTheme.size.l};
                  `
  } : {}, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_user_actions_list.UserActionsList, (0, _extends2.default)({}, props, {
    caseUserActions: lastPageUserActions,
    attachments: lastPageAttachments,
    loadingAlertData: loadingAlertData,
    manualAlertsData: manualAlertsData,
    bottomActions: bottomActions,
    commentRefs: commentRefs,
    handleManageQuote: handleManageQuote,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 13
    }
  }))) : null));
});
UserActions.displayName = 'UserActions';