"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkpadShortcuts = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _reactShortcuts = require("react-shortcuts");
var _is_text_input = require("../../lib/is_text_input");
var _use_canvas_api = require("../hooks/use_canvas_api");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/workpad/workpad_shortcuts.component.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// @ts-expect-error
class WorkpadShortcuts extends _react.default.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_toggleFullscreen", () => {
      const {
        setFullscreen,
        isFullscreen
      } = this.props;
      setFullscreen(!isFullscreen);
    });
    (0, _defineProperty2.default)(this, "nextPage", () => {
      this.props.nextPage();
    });
    (0, _defineProperty2.default)(this, "previousPage", () => {
      this.props.previousPage();
    });
    (0, _defineProperty2.default)(this, "zoomIn", () => {
      this.props.zoomIn();
    });
    (0, _defineProperty2.default)(this, "zoomOut", () => {
      this.props.zoomOut();
    });
    (0, _defineProperty2.default)(this, "resetZoom", () => {
      this.props.resetZoom();
    });
    // handle keypress events for editor events
    (0, _defineProperty2.default)(this, "_keyMap", {
      REFRESH: () => {
        (0, _use_canvas_api.forceReload)();
        this.props.fetchAllRenderables();
      },
      UNDO: this.props.undoHistory,
      REDO: this.props.redoHistory,
      GRID: () => this.props.setGrid(!this.props.grid),
      ZOOM_IN: this.zoomIn,
      ZOOM_OUT: this.zoomOut,
      ZOOM_RESET: this.resetZoom,
      PREV: this.previousPage,
      NEXT: this.nextPage,
      FULLSCREEN: this._toggleFullscreen
    });
    (0, _defineProperty2.default)(this, "_keyHandler", (action, event) => {
      if (!(0, _is_text_input.isTextInput)(event.target) && typeof this._keyMap[action] === 'function') {
        event.preventDefault();
        this._keyMap[action]();
      }
    });
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_reactShortcuts.Shortcuts, {
      name: "EDITOR",
      handler: this._keyHandler,
      targetNodeSelector: "body",
      global: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 12
      }
    });
  }
}
exports.WorkpadShortcuts = WorkpadShortcuts;