"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TreemapSelect = TreemapSelect;
exports.TreemapTypes = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/mobile/charts/mobile_treemap/treemap_select.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let TreemapTypes = exports.TreemapTypes = /*#__PURE__*/function (TreemapTypes) {
  TreemapTypes["Devices"] = "devices";
  TreemapTypes["Versions"] = "versions";
  return TreemapTypes;
}({});
const options = [{
  value: TreemapTypes.Devices,
  label: _i18n.i18n.translate('xpack.apm.transactionOverview.treemap.dropdown.devices', {
    defaultMessage: 'Devices'
  }),
  description: _i18n.i18n.translate('xpack.apm.transactionOverview.treemap.dropdown.devices.subtitle', {
    defaultMessage: 'This treemap view allows for easy and faster visual way the most used devices'
  })
}, {
  value: TreemapTypes.Versions,
  label: _i18n.i18n.translate('xpack.apm.transactionOverview.treemap.versions.devices', {
    defaultMessage: 'Versions'
  }),
  description: _i18n.i18n.translate('xpack.apm.transactionOverview.treemap.dropdown.versions.subtitle', {
    defaultMessage: 'This treemap view allows for easy and faster visual way the most used versions.'
  })
}].map(({
  value,
  label,
  description
}) => ({
  inputDisplay: label,
  value,
  dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }, label), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 9
    }
  }, description)))
}));
function TreemapSelect({
  selectedTreemap,
  onChange
}) {
  var _options$find;
  const currentTreemap = (_options$find = options.find(({
    value
  }) => value === selectedTreemap)) !== null && _options$find !== void 0 ? _options$find : options[0];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.apm.transactionOverview.treemap.title', {
    defaultMessage: 'Most used {currentTreemap}',
    values: {
      currentTreemap: currentTreemap.value
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.apm.transactionOverview.treemap.subtitle', {
    defaultMessage: 'Treemap showing the total and most used {currentTreemap}',
    values: {
      currentTreemap: currentTreemap.value
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    style: {
      fontWeight: 'bold'
    },
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.apm.transactionOverview.treemap.show', {
    defaultMessage: 'Show'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    fullWidth: true,
    style: {
      minWidth: '300px'
    },
    options: options,
    valueOfSelected: selectedTreemap,
    onChange: onChange,
    itemLayoutAlign: "top",
    hasDividers: true,
    "aria-label": _i18n.i18n.translate('xpack.apm.transactionOverview.treemap.select.ariaLabel', {
      defaultMessage: 'Treemap'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 11
    }
  }))));
}