"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRuleTypesInternalResponseSchema = exports.getRuleTypesInternalResponseBodySchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _v = require("../../external/schemas/v1");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getRuleTypesInternalResponseBodySchema = exports.getRuleTypesInternalResponseBodySchema = _configSchema.schema.arrayOf(_configSchema.schema.object({
  solution: _configSchema.schema.oneOf([_configSchema.schema.literal('stack'), _configSchema.schema.literal('observability'), _configSchema.schema.literal('security')], {
    meta: {
      description: 'An identifier for the solution that owns this rule type.'
    }
  }),
  action_groups: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_v.actionGroupSchema, {
    meta: {
      description: "An explicit list of groups for which the rule type can schedule actions, each with the action group's unique ID and human readable name. Rule actions validation uses this configuration to ensure that groups are valid."
    }
  })),
  action_variables: _configSchema.schema.maybe(_configSchema.schema.object({
    context: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_v.actionVariableSchema)),
    state: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_v.actionVariableSchema)),
    params: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_v.actionVariableSchema))
  }, {
    meta: {
      description: 'A list of action variables that the rule type makes available via context and state in action parameter templates, and a short human readable description. When you create a rule in Kibana, it uses this information to prompt you for these variables in action parameter editors.'
    }
  })),
  alerts: _configSchema.schema.maybe(_configSchema.schema.object({
    context: _configSchema.schema.string({
      meta: {
        description: 'The namespace for this rule type.'
      }
    }),
    mappings: _configSchema.schema.maybe(_configSchema.schema.object({
      dynamic: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(false), _configSchema.schema.literal('strict')], {
        meta: {
          description: 'Indicates whether new fields are added dynamically.'
        }
      })),
      fieldMap: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any(), {
        meta: {
          description: 'Mapping information for each field supported in alerts as data documents for this rule type. For more information about mapping parameters, refer to the Elasticsearch documentation.'
        }
      }),
      shouldWrite: _configSchema.schema.maybe(_configSchema.schema.boolean({
        meta: {
          description: 'Indicates whether the rule should write out alerts as data.'
        }
      })),
      useEcs: _configSchema.schema.maybe(_configSchema.schema.boolean({
        meta: {
          description: 'Indicates whether to include the ECS component template for the alerts.'
        }
      }))
    }))
  }, {
    meta: {
      description: 'Details for writing alerts as data documents for this rule type.'
    }
  })),
  authorized_consumers: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.object({
    read: _configSchema.schema.boolean(),
    all: _configSchema.schema.boolean()
  }), {
    meta: {
      description: 'The list of the plugins IDs that have access to the rule type.'
    }
  }),
  auto_recover_alerts: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  category: _configSchema.schema.string({
    meta: {
      description: 'The rule category, which is used by features such as category-specific maintenance windows.'
    }
  }),
  default_action_group_id: _configSchema.schema.string({
    meta: {
      description: 'The default identifier for the rule type group.'
    }
  }),
  default_schedule_interval: _configSchema.schema.maybe(_configSchema.schema.string()),
  does_set_recovery_context: _configSchema.schema.maybe(_configSchema.schema.boolean({
    meta: {
      description: 'Indicates whether the rule passes context variables to its recovery action.'
    }
  })),
  enabled_in_license: _configSchema.schema.boolean({
    meta: {
      description: 'Indicates whether the rule type is enabled or disabled based on the subscription.'
    }
  }),
  has_alerts_mappings: _configSchema.schema.boolean({
    meta: {
      description: 'Indicates whether the rule type has custom mappings for the alert data.'
    }
  }),
  id: _configSchema.schema.string({
    meta: {
      description: 'The unique identifier for the rule type.'
    }
  }),
  is_internally_managed: _configSchema.schema.boolean({
    meta: {
      description: 'Indicates whether the rule type is internally managed by the system. Rules of this type can not be edited by users.'
    }
  }),
  is_exportable: _configSchema.schema.boolean({
    meta: {
      description: 'Indicates whether the rule type is exportable in Stack Management > Saved Objects.'
    }
  }),
  minimum_license_required: _configSchema.schema.oneOf([_configSchema.schema.literal('basic'), _configSchema.schema.literal('gold'), _configSchema.schema.literal('platinum'), _configSchema.schema.literal('standard'), _configSchema.schema.literal('enterprise'), _configSchema.schema.literal('trial')], {
    meta: {
      description: 'The subscriptions required to use the rule type.'
    }
  }),
  name: _configSchema.schema.string({
    meta: {
      description: 'The descriptive name of the rule type.'
    }
  }),
  producer: _configSchema.schema.string({
    meta: {
      description: 'An identifier for the application that produces this rule type.'
    }
  }),
  recovery_action_group: _v.actionGroupSchema,
  rule_task_timeout: _configSchema.schema.maybe(_configSchema.schema.string())
}));
const getRuleTypesInternalResponseSchema = exports.getRuleTypesInternalResponseSchema = _configSchema.schema.object({
  body: getRuleTypesInternalResponseBodySchema
});