"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiFlyoutFooterStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
var _high_contrast = require("../../global_styling/functions/high_contrast");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiFlyoutFooterStyles = exports.euiFlyoutFooterStyles = function euiFlyoutFooterStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiFlyoutFooter: /*#__PURE__*/(0, _react.css)("background-color:", euiTheme.components.flyoutFooterBackground, ";flex-grow:0;", (0, _high_contrast.highContrastModeStyles)(euiThemeContext, {
      preferred: (0, _global_styling.logicalCSS)('border-top', euiTheme.border.thin)
    }), ";;label:euiFlyoutFooter;")
  };
};