"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Tabs = void 0;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-utils-plugin/public");
var _public2 = require("@kbn/data-views-plugin/public");
var _public3 = require("@kbn/kibana-react-plugin/public");
var _edit_index_pattern_state_container = require("../edit_index_pattern_state_container");
var _constants = require("../constants");
var _source_filters_table = require("../source_filters_table");
var _indexed_fields_table = require("../indexed_fields_table");
var _scripted_fields_table = require("../scripted_fields_table");
var _relationships_table = require("../relationships_table");
var _utils = require("./utils");
var _utils2 = require("../../utils");
var _state_utils = require("../../../management_app/state_utils");
var _data_view_mgmt_selectors = require("../../../management_app/data_view_mgmt_selectors");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_management/public/components/edit_index_pattern/tabs/tabs.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const searchAriaLabel = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.fields.searchAria', {
  defaultMessage: 'Search fields'
});
const filterLabel = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.fields.filter', {
  defaultMessage: 'Field type'
});
const filterAriaLabel = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.fields.filterAria', {
  defaultMessage: 'Filter field types'
});
const schemaFilterLabel = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.fields.schema', {
  defaultMessage: 'Schema type'
});
const schemaAriaLabel = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.fields.schemaAria', {
  defaultMessage: 'Filter schema types'
});
const scriptedFieldFilterLabel = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.fields.scriptedFieldFilter', {
  defaultMessage: 'All languages'
});
const scriptedFieldAriaLabel = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.fields.scriptedFieldFilterAria', {
  defaultMessage: 'Filter scripted field languages'
});
const schemaOptionRuntime = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.fields.runtime', {
  defaultMessage: 'Runtime'
});
const schemaOptionIndexed = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.fields.indexed', {
  defaultMessage: 'Indexed'
});
const filterPlaceholder = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.fields.filterPlaceholder', {
  defaultMessage: 'Search'
});
const addFieldButtonLabel = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.fields.addFieldButtonLabel', {
  defaultMessage: 'Add field'
});
const refreshAriaLabel = _i18n.i18n.translate('indexPatternManagement.editDataView.refreshAria', {
  defaultMessage: 'Refresh'
});
const refreshTooltip = _i18n.i18n.translate('indexPatternManagement.editDataView.refreshTooltip', {
  defaultMessage: 'Refresh local copy of data view field list'
});
const SCHEMA_ITEMS = [{
  value: 'runtime',
  name: schemaOptionRuntime
}, {
  value: 'indexed',
  name: schemaOptionIndexed
}];
const Tabs = ({
  indexPattern,
  saveIndexPattern,
  history,
  refreshFields,
  relationships,
  allowedTypes,
  compositeRuntimeFields,
  refreshIndexPatternClick,
  isRefreshing
}) => {
  const {
    uiSettings,
    docLinks,
    dataViewFieldEditor,
    overlays,
    dataViews,
    http,
    application,
    savedObjectsManagement,
    dataViewMgmtService,
    ...startServices
  } = (0, _public3.useKibana)().services;
  const [fieldFilter, setFieldFilter] = (0, _react.useState)('');
  const [syncingStateFunc, setSyncingStateFunc] = (0, _react.useState)({});
  const [scriptedFieldLanguageFilter, setScriptedFieldLanguageFilter] = (0, _react.useState)([]);
  const [isScriptedFieldFilterOpen, setIsScriptedFieldFilterOpen] = (0, _react.useState)(false);
  const [indexedFieldTypeFilter, setIndexedFieldTypeFilter] = (0, _react.useState)([]);
  const [isIndexedFilterOpen, setIsIndexedFilterOpen] = (0, _react.useState)(false);
  const [schemaFieldTypeFilter, setSchemaFieldTypeFilter] = (0, _react.useState)([]);
  const [isSchemaFilterOpen, setIsSchemaFilterOpen] = (0, _react.useState)(false);
  const fields = (0, _state_utils.useStateSelector)(dataViewMgmtService.state$, _data_view_mgmt_selectors.fieldsSelector);
  const indexedFieldTypes = (0, _utils.convertToEuiFilterOptions)((0, _state_utils.useStateSelector)(dataViewMgmtService.state$, _data_view_mgmt_selectors.indexedFieldTypeSelector));
  const scriptedFieldLanguages = (0, _state_utils.useStateSelector)(dataViewMgmtService.state$, _data_view_mgmt_selectors.scriptedFieldLangsSelector);
  const closeEditorHandler = (0, _react.useRef)();
  const {
    DeleteRuntimeFieldProvider
  } = dataViewFieldEditor;
  const filteredIndexedFieldTypeFilter = (0, _react.useMemo)(() => {
    return indexedFieldTypeFilter.filter(fieldType => indexedFieldTypes.some(item => item.value === fieldType));
  }, [indexedFieldTypeFilter, indexedFieldTypes]);
  const filteredSchemaFieldTypeFilter = (0, _react.useMemo)(() => {
    return (0, _lodash.uniq)(schemaFieldTypeFilter.filter(schemaFieldType => SCHEMA_ITEMS.some(item => item.value === schemaFieldType)));
  }, [schemaFieldTypeFilter]);
  const updateTab = (0, _react.useCallback)(tab => {
    var _syncingStateFunc$set;
    (_syncingStateFunc$set = syncingStateFunc.setCurrentTab) === null || _syncingStateFunc$set === void 0 ? void 0 : _syncingStateFunc$set.call(syncingStateFunc, tab.id);
  }, [syncingStateFunc]);
  const updateFieldTypeFilter = (0, _react.useCallback)(newIndexedFieldTypeFilter => {
    var _syncingStateFunc$set2;
    syncingStateFunc === null || syncingStateFunc === void 0 ? void 0 : (_syncingStateFunc$set2 = syncingStateFunc.setCurrentFieldTypes) === null || _syncingStateFunc$set2 === void 0 ? void 0 : _syncingStateFunc$set2.call(syncingStateFunc, newIndexedFieldTypeFilter);
  }, [syncingStateFunc]);
  const updateSchemaFieldTypeFilter = (0, _react.useCallback)(newSchemaFieldTypeFilter => {
    var _syncingStateFunc$set3;
    syncingStateFunc === null || syncingStateFunc === void 0 ? void 0 : (_syncingStateFunc$set3 = syncingStateFunc.setCurrentSchemaFieldTypes) === null || _syncingStateFunc$set3 === void 0 ? void 0 : _syncingStateFunc$set3.call(syncingStateFunc, newSchemaFieldTypeFilter);
  }, [syncingStateFunc]);
  const updateFieldFilter = (0, _react.useCallback)(newFieldFilter => {
    var _syncingStateFunc$set4;
    syncingStateFunc === null || syncingStateFunc === void 0 ? void 0 : (_syncingStateFunc$set4 = syncingStateFunc.setCurrentFieldFilter) === null || _syncingStateFunc$set4 === void 0 ? void 0 : _syncingStateFunc$set4.call(syncingStateFunc, newFieldFilter || undefined);
  }, [syncingStateFunc]);
  const closeFieldEditor = (0, _react.useCallback)(() => {
    if (closeEditorHandler.current) {
      closeEditorHandler.current();
    }
  }, []);
  const openFieldEditor = (0, _react.useCallback)(async fieldName => {
    closeEditorHandler.current = await dataViewFieldEditor.openEditor({
      ctx: {
        dataView: indexPattern
      },
      onSave: refreshFields,
      fieldName
    });
  }, [dataViewFieldEditor, indexPattern, refreshFields]);
  (0, _react.useEffect)(() => {
    return () => {
      // When the component unmounts, make sure to close the field editor
      closeFieldEditor();
    };
  }, [closeFieldEditor]);
  const fieldWildcardMatcherDecorated = (0, _react.useCallback)(filters => (0, _public.fieldWildcardMatcher)(filters, uiSettings.get(_public2.META_FIELDS)), [uiSettings]);
  const refreshRef = (0, _react.useRef)(null);
  const userEditPermission = dataViews.getCanSaveSync();
  const getFilterSection = (0, _react.useCallback)(type => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 305,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 306,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
      fullWidth: true,
      placeholder: filterPlaceholder,
      value: fieldFilter,
      onChange: e => updateFieldFilter(e.target.value),
      "data-test-subj": "indexPatternFieldFilter",
      "aria-label": searchAriaLabel,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 307,
        columnNumber: 13
      }
    })), type === _constants.TAB_INDEXED_FIELDS && indexedFieldTypes.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 318,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 319,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      anchorPosition: "downCenter",
      "data-test-subj": "indexedFieldTypeFilterDropdown-popover",
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
        "aria-label": filterAriaLabel,
        "data-test-subj": "indexedFieldTypeFilterDropdown",
        iconType: "arrowDown",
        onClick: () => setIsIndexedFilterOpen(!isIndexedFilterOpen),
        isSelected: isIndexedFilterOpen,
        numFilters: indexedFieldTypes.length,
        hasActiveFilters: filteredIndexedFieldTypeFilter.length > 0,
        numActiveFilters: filteredIndexedFieldTypeFilter.length,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 324,
          columnNumber: 23
        }
      }, filterLabel),
      isOpen: isIndexedFilterOpen,
      closePopover: () => setIsIndexedFilterOpen(false),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 320,
        columnNumber: 19
      }
    }, indexedFieldTypes.map(item => {
      const isSelected = filteredIndexedFieldTypeFilter.includes(item.value);
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterSelectItem, {
        checked: isSelected ? 'on' : undefined,
        key: item.value,
        onClick: () => {
          updateFieldTypeFilter(isSelected ? filteredIndexedFieldTypeFilter.filter(f => f !== item.value) : [...filteredIndexedFieldTypeFilter, item.value]);
        },
        "data-test-subj": `indexedFieldTypeFilterDropdown-option-${item.value}${isSelected ? '-checked' : ''}`,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 343,
          columnNumber: 25
        }
      }, item.name);
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      anchorPosition: "downCenter",
      "data-test-subj": "schemaFieldTypeFilterDropdown-popover",
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
        "aria-label": schemaAriaLabel,
        "data-test-subj": "schemaFieldTypeFilterDropdown",
        iconType: "arrowDown",
        onClick: () => setIsSchemaFilterOpen(!isSchemaFilterOpen),
        isSelected: isSchemaFilterOpen,
        numFilters: SCHEMA_ITEMS.length,
        hasActiveFilters: filteredSchemaFieldTypeFilter.length > 0,
        numActiveFilters: filteredSchemaFieldTypeFilter.length,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 366,
          columnNumber: 23
        }
      }, schemaFilterLabel),
      isOpen: isSchemaFilterOpen,
      closePopover: () => setIsSchemaFilterOpen(false),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 362,
        columnNumber: 19
      }
    }, SCHEMA_ITEMS.map(item => {
      const isSelected = filteredSchemaFieldTypeFilter.includes(item.value);
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterSelectItem, {
        checked: isSelected ? 'on' : undefined,
        key: item.value,
        onClick: () => {
          updateSchemaFieldTypeFilter(isSelected ? filteredSchemaFieldTypeFilter.filter(f => f !== item.value) : [...filteredSchemaFieldTypeFilter, item.value]);
        },
        "data-test-subj": `schemaFieldTypeFilterDropdown-option-${item.value}${isSelected ? '-checked' : ''}`,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 385,
          columnNumber: 25
        }
      }, item.name);
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 406,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 407,
          columnNumber: 38
        }
      }, refreshTooltip),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 407,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      buttonRef: refreshRef,
      onClick: () => {
        refreshIndexPatternClick();
        // clear tooltip focus
        if (refreshRef.current) {
          refreshRef.current.blur();
        }
      },
      iconType: "refresh",
      "aria-label": refreshAriaLabel,
      "data-test-subj": "refreshDataViewButton",
      isLoading: isRefreshing,
      isDisabled: isRefreshing,
      size: "m",
      color: "success",
      className: "eui-fullWidth",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 408,
        columnNumber: 19
      }
    }, refreshAriaLabel))), userEditPermission && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 431,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "m",
      onClick: () => openFieldEditor(),
      "data-test-subj": "addField",
      iconType: "plusInCircle",
      "aria-label": addFieldButtonLabel,
      color: "primary",
      fill: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 432,
        columnNumber: 19
      }
    }, addFieldButtonLabel))), type === _constants.TAB_SCRIPTED_FIELDS && scriptedFieldLanguages.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 448,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 449,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      anchorPosition: "downCenter",
      "data-test-subj": "scriptedFieldLanguageFilterDropdown-popover",
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
        "aria-label": scriptedFieldAriaLabel,
        "data-test-subj": "scriptedFieldLanguageFilterDropdown",
        iconType: "arrowDown",
        onClick: () => setIsScriptedFieldFilterOpen(!isScriptedFieldFilterOpen),
        isSelected: isScriptedFieldFilterOpen,
        numFilters: scriptedFieldLanguages.length,
        hasActiveFilters: !!scriptedFieldLanguages.find(item => item.checked === 'on'),
        numActiveFilters: scriptedFieldLanguages.filter(item => item.checked === 'on').length,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 454,
          columnNumber: 21
        }
      }, scriptedFieldFilterLabel),
      isOpen: isScriptedFieldFilterOpen,
      closePopover: () => setIsScriptedFieldFilterOpen(false),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 450,
        columnNumber: 17
      }
    }, scriptedFieldLanguages.map((item, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFilterSelectItem, {
      checked: item.checked,
      key: item.value,
      onClick: () => {
        // this does the filtering
        setScriptedFieldLanguageFilter(item.checked ? scriptedFieldLanguageFilter.filter(f => f !== item.value) : [...scriptedFieldLanguageFilter, item.value]);
        // updates the UI
        dataViewMgmtService.setScriptedFieldLangSelection(index);
      },
      "data-test-subj": `scriptedFieldLanguageFilterDropdown-option-${item.value}${item.checked ? '-checked' : ''}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 475,
        columnNumber: 21
      }
    }, item.name))))));
  }, [dataViewMgmtService, fieldFilter, filteredSchemaFieldTypeFilter, filteredIndexedFieldTypeFilter, indexedFieldTypes, isIndexedFilterOpen, scriptedFieldLanguageFilter, scriptedFieldLanguages, isScriptedFieldFilterOpen, isSchemaFilterOpen, openFieldEditor, userEditPermission, updateFieldFilter, updateFieldTypeFilter, updateSchemaFieldTypeFilter, isRefreshing, refreshIndexPatternClick]);
  const getContent = (0, _react.useCallback)(type => {
    switch (type) {
      case _constants.TAB_INDEXED_FIELDS:
        return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 528,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
          size: "m",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 529,
            columnNumber: 15
          }
        }), getFilterSection(type), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
          size: "m",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 531,
            columnNumber: 15
          }
        }), /*#__PURE__*/_react.default.createElement(DeleteRuntimeFieldProvider, {
          dataView: indexPattern,
          onDelete: refreshFields,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 532,
            columnNumber: 15
          }
        }, deleteField => /*#__PURE__*/_react.default.createElement(_indexed_fields_table.IndexedFieldsTable, {
          fields: fields,
          compositeRuntimeFields: compositeRuntimeFields,
          indexPattern: indexPattern,
          fieldFilter: fieldFilter,
          fieldWildcardMatcher: fieldWildcardMatcherDecorated,
          indexedFieldTypeFilter: filteredIndexedFieldTypeFilter,
          schemaFieldTypeFilter: filteredSchemaFieldTypeFilter,
          helpers: {
            editField: openFieldEditor,
            deleteField,
            getFieldInfo: _utils2.getFieldInfo
          },
          openModal: overlays.openModal,
          userEditPermission: dataViews.getCanSaveSync(),
          startServices: startServices,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 534,
            columnNumber: 19
          }
        })));
      case _constants.TAB_SCRIPTED_FIELDS:
        return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 557,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
          size: "m",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 558,
            columnNumber: 15
          }
        }), getFilterSection(type), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
          size: "m",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 560,
            columnNumber: 15
          }
        }), /*#__PURE__*/_react.default.createElement(_scripted_fields_table.ScriptedFieldsTable, {
          indexPattern: indexPattern,
          saveIndexPattern: saveIndexPattern,
          fieldFilter: fieldFilter,
          scriptedFieldLanguageFilter: scriptedFieldLanguageFilter,
          helpers: {
            redirectToRoute: field => {
              history.push((0, _utils.getPath)(field, indexPattern));
            }
          },
          onRemoveField: () => dataViewMgmtService.refreshFields(),
          painlessDocLink: docLinks.links.scriptedFields.painless,
          userEditPermission: dataViews.getCanSaveSync(),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 561,
            columnNumber: 15
          }
        }));
      case _constants.TAB_SOURCE_FILTERS:
        return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 579,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
          size: "m",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 580,
            columnNumber: 15
          }
        }), getFilterSection(type), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
          size: "m",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 582,
            columnNumber: 15
          }
        }), /*#__PURE__*/_react.default.createElement(_source_filters_table.SourceFiltersTable, {
          saveIndexPattern: async dv => {
            await saveIndexPattern(dv);
            dataViewMgmtService.refreshFields();
          },
          indexPattern: indexPattern,
          filterFilter: fieldFilter,
          fieldWildcardMatcher: fieldWildcardMatcherDecorated,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 583,
            columnNumber: 15
          }
        }));
      case _constants.TAB_RELATIONSHIPS:
        return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 596,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
          size: "m",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 597,
            columnNumber: 15
          }
        }), /*#__PURE__*/_react.default.createElement(_relationships_table.RelationshipsTable, {
          basePath: http.basePath,
          id: indexPattern.id,
          capabilities: application.capabilities,
          relationships: relationships,
          allowedTypes: allowedTypes,
          navigateToUrl: application.navigateToUrl,
          getDefaultTitle: savedObjectsManagement.getDefaultTitle,
          getSavedObjectLabel: savedObjectsManagement.getSavedObjectLabel,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 598,
            columnNumber: 15
          }
        }));
    }
  }, [docLinks.links.scriptedFields.painless, fieldFilter, fieldWildcardMatcherDecorated, fields, getFilterSection, history, indexPattern, filteredIndexedFieldTypeFilter, filteredSchemaFieldTypeFilter, scriptedFieldLanguageFilter, saveIndexPattern, openFieldEditor, DeleteRuntimeFieldProvider, refreshFields, overlays, startServices, dataViews, compositeRuntimeFields, http, application, savedObjectsManagement, allowedTypes, relationships, dataViewMgmtService]);
  const euiTabs = (0, _react.useMemo)(() => (0, _utils.getTabs)(indexPattern, fieldFilter, relationships.length, dataViews.scriptedFieldsEnabled).map(tab => {
    return {
      ...tab,
      content: getContent(tab.id)
    };
  }), [fieldFilter, getContent, indexPattern, relationships, dataViews.scriptedFieldsEnabled]);
  const [selectedTabId, setSelectedTabId] = (0, _react.useState)(euiTabs[0].id);
  (0, _react.useEffect)(() => {
    const {
      startSyncingState,
      stopSyncingState,
      setCurrentTab,
      setCurrentFieldTypes,
      setCurrentFieldFilter,
      setCurrentSchemaFieldTypes,
      stateContainer
    } = (0, _edit_index_pattern_state_container.createEditIndexPatternPageStateContainer)({
      useHashedUrl: uiSettings.get('state:storeInSessionStorage'),
      defaultTab: _constants.TAB_INDEXED_FIELDS
    });
    startSyncingState();
    setSyncingStateFunc({
      setCurrentTab,
      setCurrentFieldTypes,
      setCurrentFieldFilter,
      setCurrentSchemaFieldTypes
    });
    setSelectedTabId(stateContainer.selectors.tab());
    setIndexedFieldTypeFilter(currentValue => {
      var _stateContainer$selec;
      return (_stateContainer$selec = stateContainer.selectors.fieldTypes()) !== null && _stateContainer$selec !== void 0 ? _stateContainer$selec : [];
    });
    setSchemaFieldTypeFilter(currentValue => {
      var _stateContainer$selec2;
      return (_stateContainer$selec2 = stateContainer.selectors.schemaFieldTypes()) !== null && _stateContainer$selec2 !== void 0 ? _stateContainer$selec2 : [];
    });
    setFieldFilter(currentValue => {
      var _stateContainer$selec3;
      return (_stateContainer$selec3 = stateContainer.selectors.fieldFilter()) !== null && _stateContainer$selec3 !== void 0 ? _stateContainer$selec3 : '';
    });
    const stateSubscription = stateContainer.state$.subscribe(() => {
      setSelectedTabId(stateContainer.selectors.tab());
      setIndexedFieldTypeFilter(currentValue => {
        var _stateContainer$selec4;
        return (_stateContainer$selec4 = stateContainer.selectors.fieldTypes()) !== null && _stateContainer$selec4 !== void 0 ? _stateContainer$selec4 : [];
      });
      setSchemaFieldTypeFilter(currentValue => {
        var _stateContainer$selec5;
        return (_stateContainer$selec5 = stateContainer.selectors.schemaFieldTypes()) !== null && _stateContainer$selec5 !== void 0 ? _stateContainer$selec5 : [];
      });
      setFieldFilter(currentValue => {
        var _stateContainer$selec6;
        return (_stateContainer$selec6 = stateContainer.selectors.fieldFilter()) !== null && _stateContainer$selec6 !== void 0 ? _stateContainer$selec6 : '';
      });
    });
    return () => {
      stateSubscription.unsubscribe();
      stopSyncingState();
    };
  }, [uiSettings]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    tabs: euiTabs,
    selectedTab: euiTabs.find(tab => tab.id === selectedTabId),
    onTabClick: updateTab,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 696,
      columnNumber: 5
    }
  });
};
exports.Tabs = Tabs;