"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserActionsList = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _helpers = require("./helpers");
var _use_cases_context = require("../cases_context/use_cases_context");
var _builder = require("./builder");
var _navigation = require("../../common/navigation");
var _use_user_actions_handler = require("./use_user_actions_handler");
var _utils = require("../utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/user_actions/user_actions_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getCommentListCss = euiTheme => (0, _react2.css)`
  & .userAction__comment.outlined .euiCommentEvent {
    outline: solid 5px ${euiTheme.colors.lightShade};
    margin: 0.5em;
    transition: 0.8s;
  }

  ${_utils.scaledMarkdownImages}

  & .draftFooter {
    & .euiCommentEvent__body {
      padding: 0;
    }
  }

  & .euiComment.isEdit {
    & .euiCommentEvent {
      border: none;
      box-shadow: none;
    }

    & .euiCommentEvent__body {
      padding: 0;
    }

    & .euiCommentEvent__header {
      display: none;
    }
  }

  & .comment-action.empty-comment [class*='euiCommentEvent-regular'] {
    box-shadow: none;
    .euiCommentEvent__header {
      padding: ${euiTheme.size.m} ${euiTheme.size.s};
      border-bottom: 0;
    }
  }
`;
const UserActionsList = exports.UserActionsList = /*#__PURE__*/_react.default.memo(({
  caseUserActions,
  attachments,
  caseConnectors,
  userProfiles,
  currentUserProfile,
  data: caseData,
  casesConfiguration,
  getRuleDetailsHref,
  actionsNavigation,
  onRuleDetailsClick,
  onShowAlertDetails,
  loadingAlertData,
  manualAlertsData,
  commentRefs,
  handleManageQuote,
  bottomActions = [],
  isExpandable = false
}) => {
  const {
    externalReferenceAttachmentTypeRegistry,
    persistableStateAttachmentTypeRegistry
  } = (0, _use_cases_context.useCasesContext)();
  const {
    owner
  } = (0, _use_cases_context.useCasesContext)();
  const {
    commentId
  } = (0, _navigation.useCaseViewParams)();
  const [initLoading, setInitLoading] = (0, _react.useState)(true);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    loadingCommentIds,
    selectedOutlineCommentId,
    manageMarkdownEditIds,
    handleManageMarkdownEditId,
    handleOutlineComment,
    handleSaveComment,
    handleDeleteComment
  } = (0, _use_user_actions_handler.useUserActionsHandler)();
  const builtUserActions = (0, _react.useMemo)(() => {
    if (!caseUserActions) {
      return [];
    }
    return caseUserActions.reduce((userActions, userAction, index) => {
      if (!(0, _helpers.isUserActionTypeSupported)(userAction.type)) {
        return userActions;
      }
      const builder = _builder.builderMap[userAction.type];
      if (builder == null) {
        return userActions;
      }
      const userActionBuilder = builder({
        appId: owner[0],
        caseData,
        casesConfiguration,
        caseConnectors,
        externalReferenceAttachmentTypeRegistry,
        persistableStateAttachmentTypeRegistry,
        userAction,
        userProfiles,
        currentUserProfile,
        attachments,
        index,
        commentRefs,
        manageMarkdownEditIds,
        selectedOutlineCommentId,
        loadingCommentIds,
        loadingAlertData,
        alertData: manualAlertsData,
        euiTheme,
        handleOutlineComment,
        handleManageMarkdownEditId,
        handleDeleteComment,
        handleSaveComment,
        handleManageQuote,
        onShowAlertDetails,
        actionsNavigation,
        getRuleDetailsHref,
        onRuleDetailsClick
      });
      return [...userActions, ...userActionBuilder.build()];
    }, []);
  }, [caseUserActions, owner, caseData, casesConfiguration, caseConnectors, externalReferenceAttachmentTypeRegistry, persistableStateAttachmentTypeRegistry, userProfiles, currentUserProfile, attachments, commentRefs, manageMarkdownEditIds, selectedOutlineCommentId, loadingCommentIds, loadingAlertData, manualAlertsData, euiTheme, handleOutlineComment, handleManageMarkdownEditId, handleDeleteComment, handleSaveComment, handleManageQuote, onShowAlertDetails, actionsNavigation, getRuleDetailsHref, onRuleDetailsClick]);
  const comments = bottomActions !== null && bottomActions !== void 0 && bottomActions.length ? [...builtUserActions, ...bottomActions] : [...builtUserActions];
  (0, _react.useEffect)(() => {
    if (commentId != null && initLoading) {
      setInitLoading(false);
      handleOutlineComment(commentId);
    }
  }, [commentId, initLoading, handleOutlineComment]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCommentList, {
    className: isExpandable ? 'commentList--hasShowMore' : '',
    css: getCommentListCss(euiTheme),
    comments: comments,
    "data-test-subj": "user-actions-list",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 7
    }
  });
});
UserActionsList.displayName = 'UserActionsList';