"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRuleId = exports.createAlertAttachmentUserActionBuilder = void 0;
exports.getRuleInfo = getRuleInfo;
exports.getRuleName = void 0;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _timestamp = require("../timestamp");
var _alert_event = require("./alert_event");
var _show_alert = require("./show_alert");
var _show_alert_table_link = require("./show_alert_table_link");
var _hoverable_user_with_avatar_resolver = require("../../user_profiles/hoverable_user_with_avatar_resolver");
var _content_toolbar = require("../content_toolbar");
var _alert_property_actions = require("../property_actions/alert_property_actions");
var _translations = require("./translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/user_actions/comment/alert.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getSingleAlertUserAction = ({
  userAction,
  userProfiles,
  attachment,
  alertData,
  loadingAlertData,
  loadingCommentIds,
  getRuleDetailsHref,
  onRuleDetailsClick,
  onShowAlertDetails,
  handleDeleteComment
}) => {
  const alertId = getNonEmptyField(attachment.alertId);
  const alertIndex = getNonEmptyField(attachment.index);
  if (!alertId || !alertIndex) {
    return [];
  }
  const alertField = alertData[alertId];
  const ruleId = getRuleId(attachment, alertField);
  const ruleName = getRuleName(attachment, alertField);
  return [{
    username: /*#__PURE__*/_react.default.createElement(_hoverable_user_with_avatar_resolver.HoverableUserWithAvatarResolver, {
      user: userAction.createdBy,
      userProfiles: userProfiles,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 9
      }
    }),
    eventColor: 'subdued',
    event: /*#__PURE__*/_react.default.createElement(_alert_event.SingleAlertCommentEvent, {
      actionId: userAction.id,
      getRuleDetailsHref: getRuleDetailsHref,
      loadingAlertData: loadingAlertData,
      onRuleDetailsClick: onRuleDetailsClick,
      ruleId: ruleId,
      ruleName: ruleName,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 9
      }
    }),
    'data-test-subj': `user-action-alert-${userAction.type}-${userAction.action}-action-${userAction.id}`,
    timestamp: /*#__PURE__*/_react.default.createElement(_timestamp.UserActionTimestamp, {
      createdAt: userAction.createdAt,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 18
      }
    }),
    timelineAvatar: 'bell',
    actions: /*#__PURE__*/_react.default.createElement(_content_toolbar.UserActionContentToolbar, {
      id: attachment.id,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_show_alert.UserActionShowAlert, {
      id: userAction.id,
      alertId: alertId,
      index: alertIndex,
      onShowAlertDetails: onShowAlertDetails,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_alert_property_actions.AlertPropertyActions, {
      onDelete: () => handleDeleteComment(attachment.id, (0, _translations.DELETE_ALERTS_SUCCESS_TITLE)(1)),
      isLoading: loadingCommentIds.includes(attachment.id),
      totalAlerts: 1,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 11
      }
    }))
  }];
};
const getMultipleAlertsUserAction = ({
  userAction,
  userProfiles,
  attachment,
  alertData,
  loadingAlertData,
  loadingCommentIds,
  getRuleDetailsHref,
  onRuleDetailsClick,
  handleDeleteComment
}) => {
  if (!Array.isArray(attachment.alertId)) {
    return [];
  }
  const totalAlerts = attachment.alertId.length;
  const {
    ruleId,
    ruleName
  } = getRuleInfo(attachment, alertData);
  return [{
    username: /*#__PURE__*/_react.default.createElement(_hoverable_user_with_avatar_resolver.HoverableUserWithAvatarResolver, {
      user: userAction.createdBy,
      userProfiles: userProfiles,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 123,
        columnNumber: 9
      }
    }),
    eventColor: 'subdued',
    event: /*#__PURE__*/_react.default.createElement(_alert_event.MultipleAlertsCommentEvent, {
      actionId: userAction.id,
      loadingAlertData: loadingAlertData,
      totalAlerts: totalAlerts,
      ruleId: ruleId,
      ruleName: ruleName,
      getRuleDetailsHref: getRuleDetailsHref,
      onRuleDetailsClick: onRuleDetailsClick,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 9
      }
    }),
    'data-test-subj': `user-action-alert-${userAction.type}-${userAction.action}-action-${userAction.id}`,
    timestamp: /*#__PURE__*/_react.default.createElement(_timestamp.UserActionTimestamp, {
      createdAt: userAction.createdAt,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 18
      }
    }),
    timelineAvatar: 'bell',
    actions: /*#__PURE__*/_react.default.createElement(_content_toolbar.UserActionContentToolbar, {
      id: attachment.id,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 141,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 142,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_show_alert_table_link.ShowAlertTableLink, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_alert_property_actions.AlertPropertyActions, {
      onDelete: () => handleDeleteComment(attachment.id, (0, _translations.DELETE_ALERTS_SUCCESS_TITLE)(totalAlerts)),
      isLoading: loadingCommentIds.includes(attachment.id),
      totalAlerts: totalAlerts,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 11
      }
    }))
  }];
};
const createAlertAttachmentUserActionBuilder = params => ({
  build: () => {
    const {
      attachment
    } = params;
    const alertId = Array.isArray(attachment.alertId) ? attachment.alertId : [attachment.alertId];
    if (alertId.length === 1) {
      return getSingleAlertUserAction(params);
    }
    return getMultipleAlertsUserAction(params);
  }
});
exports.createAlertAttachmentUserActionBuilder = createAlertAttachmentUserActionBuilder;
const getFirstItem = items => {
  return Array.isArray(items) ? items[0] : items !== null && items !== void 0 ? items : null;
};
const getRuleId = (attachment, alertData) => {
  var _attachment$rule;
  return getRuleField({
    attachmentRuleField: attachment === null || attachment === void 0 ? void 0 : (_attachment$rule = attachment.rule) === null || _attachment$rule === void 0 ? void 0 : _attachment$rule.id,
    alertData,
    signalRuleFieldPath: 'signal.rule.id',
    kibanaAlertFieldPath: _ruleDataUtils.ALERT_RULE_UUID
  });
};
exports.getRuleId = getRuleId;
const getRuleName = (attachment, alertData) => {
  var _attachment$rule2;
  return getRuleField({
    attachmentRuleField: attachment === null || attachment === void 0 ? void 0 : (_attachment$rule2 = attachment.rule) === null || _attachment$rule2 === void 0 ? void 0 : _attachment$rule2.name,
    alertData,
    signalRuleFieldPath: 'signal.rule.name',
    kibanaAlertFieldPath: _ruleDataUtils.ALERT_RULE_NAME
  });
};
exports.getRuleName = getRuleName;
const getRuleField = ({
  attachmentRuleField,
  alertData,
  signalRuleFieldPath,
  kibanaAlertFieldPath
}) => {
  var _ref, _getNonEmptyField;
  const field = (_ref = (_getNonEmptyField = getNonEmptyField(attachmentRuleField)) !== null && _getNonEmptyField !== void 0 ? _getNonEmptyField : getNonEmptyField((0, _lodash.get)(alertData, signalRuleFieldPath))) !== null && _ref !== void 0 ? _ref : getNonEmptyField((0, _lodash.get)(alertData, kibanaAlertFieldPath));
  return field;
};
function getNonEmptyField(field) {
  const firstItem = getFirstItem(field);
  if (firstItem == null || (0, _lodash.isEmpty)(firstItem)) {
    return null;
  }
  return firstItem;
}
function getRuleInfo(attachment, alertData) {
  const alertId = getNonEmptyField(attachment.alertId);
  if (!alertId) {
    return {
      ruleId: null,
      ruleName: null
    };
  }
  const alertField = alertData[alertId];
  const ruleId = getRuleId(attachment, alertField);
  const ruleName = getRuleName(attachment, alertField);
  return {
    ruleId,
    ruleName
  };
}