"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VarValueField = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/var_config/var_value_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const strings = {
  getBooleanOptionsLegend: () => _i18n.i18n.translate('xpack.canvas.varConfigVarValueField.booleanOptionsLegend', {
    defaultMessage: 'Boolean value'
  }),
  getFalseOption: () => _i18n.i18n.translate('xpack.canvas.varConfigVarValueField.falseOption', {
    defaultMessage: 'False'
  }),
  getTrueOption: () => _i18n.i18n.translate('xpack.canvas.varConfigVarValueField.trueOption', {
    defaultMessage: 'True'
  })
};
const VarValueField = ({
  type,
  value,
  onChange
}) => {
  const idPrefix = (0, _eui.htmlIdGenerator)()();
  const options = [{
    id: `${idPrefix}-true`,
    label: strings.getTrueOption()
  }, {
    id: `${idPrefix}-false`,
    label: strings.getFalseOption()
  }];
  const onNumberChange = (0, _react.useCallback)(e => {
    const floatVal = parseFloat(e.target.value);
    const varValue = isNaN(floatVal) ? '' : floatVal;
    onChange(varValue);
  }, [onChange]);
  if (type === 'number') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      compressed: true,
      name: "value",
      value: value,
      onChange: onNumberChange,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 7
      }
    });
  }
  if (type === 'boolean') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
      name: "value",
      options: options,
      idSelected: `${idPrefix}-${value}`,
      onChange: id => {
        const val = id.replace(`${idPrefix}-`, '') === 'true';
        onChange(val);
      },
      buttonSize: "compressed",
      isFullWidth: true,
      legend: strings.getBooleanOptionsLegend(),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    compressed: true,
    name: "value",
    value: String(value),
    onChange: e => onChange(e.target.value),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 5
    }
  });
};
exports.VarValueField = VarValueField;