"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OpenTelemetryInstructions = OpenTelemetryInstructions;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/tutorial/config_agent/opentelemetry_instructions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function OpenTelemetryInstructions({
  apmServerUrl,
  secretToken
}) {
  const items = [{
    setting: 'OTEL_EXPORTER_OTLP_ENDPOINT',
    value: apmServerUrl ? apmServerUrl : '<apm-server-url>'
  }, {
    setting: 'OTEL_EXPORTER_OTLP_HEADERS',
    value: `Authorization=Bearer ${secretToken ? secretToken : '<secret-token>'}`
  }, {
    setting: 'OTEL_METRICS_EXPORTER',
    value: 'otlp',
    notes: 'Enable metrics when supported by your OpenTelemetry client.'
  }, {
    setting: 'OTEL_LOGS_EXPORTER',
    value: 'otlp',
    notes: 'Enable logs when supported by your OpenTelemetry client'
  }, {
    setting: 'OTEL_RESOURCE_ATTRIBUTES',
    value: 'service.name=<app-name>,service.version=<app-version>,deployment.environment=production'
  }];
  const columns = [{
    field: 'setting',
    width: '23%',
    name: _i18n.i18n.translate('xpack.apm.tutorial.config_otel.column.configSettings', {
      defaultMessage: 'Configuration setting (1)'
    })
  }, {
    field: 'value',
    width: '55%',
    name: _i18n.i18n.translate('xpack.apm.tutorial.config_otel.column.configValue', {
      defaultMessage: 'Configuration value'
    }),
    render: (_, {
      value
    }) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "accent",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 11
      }
    }, value), value && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": "apmColumnsButton",
      "aria-label": _i18n.i18n.translate('xpack.apm.tutorial.config_otel.column.value.copyIconText', {
        defaultMessage: 'Copy to clipboard'
      }),
      color: "text",
      iconType: "copy",
      onClick: () => (0, _eui.copyToClipboard)(value),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 13
      }
    }))
  }, {
    field: 'notes',
    name: _i18n.i18n.translate('xpack.apm.tutorial.config_otel.column.notes', {
      defaultMessage: 'Notes'
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: items,
    columns: columns,
    "data-test-subj": "otel-instructions-table",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.apm.tutorial.config_otel.description1",
    defaultMessage: "(1) OpenTelemetry agents and SDKs must support the {otelExporterOtlpEndpoint}, {otelExporterOtlpHeaders}, and {otelResourceAttributes} variables; some unstable components may not yet comply with this requirement.",
    values: {
      otelExporterOtlpEndpoint: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "apmOpenTelemetryInstructionsOtelExporterOtlpEndpointLink",
        target: "_blank",
        href: "https://github.com/open-telemetry/opentelemetry-specification/blob/v1.10.0/specification/protocol/exporter.md",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 108,
          columnNumber: 15
        }
      }, "OTEL_EXPORTER_OTLP_ENDPOINT"),
      otelExporterOtlpHeaders: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "apmOpenTelemetryInstructionsOtelExporterOtlpHeadersLink",
        target: "_blank",
        href: "https://github.com/open-telemetry/opentelemetry-specification/blob/v1.10.0/specification/protocol/exporter.md",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 117,
          columnNumber: 15
        }
      }, "OTEL_EXPORTER_OTLP_HEADERS"),
      otelResourceAttributes: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "apmOpenTelemetryInstructionsOtelResourceAttributesLink",
        target: "_blank",
        href: "https://github.com/open-telemetry/opentelemetry-specification/blob/v1.10.0/specification/resource/sdk.md",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 126,
          columnNumber: 15
        }
      }, "OTEL_RESOURCE_ATTRIBUTES")
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.apm.tutorial.config_otel.description2",
    defaultMessage: "The 'OTEL_METRICS_EXPORTER` and 'OTEL_LOGS_EXPORTER' environment variables may not be supported by some SDKs.",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.apm.tutorial.config_otel.description3",
    defaultMessage: "The exhaustive list of environment variables, command line parameters, and configuration code snippets (according to the OpenTelemetry specification) is available in the {otelInstrumentationGuide}. Some unstable OpenTelemetry clients may not support all features and may require alternate configuration mechanisms.",
    values: {
      otelInstrumentationGuide: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "apmOpenTelemetryInstructionsOpenTelemetryInstrumentationGuideLink",
        target: "_blank",
        href: "https://opentelemetry.io/docs/instrumentation",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 147,
          columnNumber: 15
        }
      }, _i18n.i18n.translate('xpack.apm.tutorial.config_otel.instrumentationGuide', {
        defaultMessage: 'OpenTelemetry Instrumentation guide'
      }))
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 9
    }
  })));
}