"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateSchedule = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const validateSchedule = schedule => {
  const {
    duration,
    recurring
  } = schedule;
  const {
    end,
    occurrences,
    every
  } = recurring !== null && recurring !== void 0 ? recurring : {};
  if (every) {
    var _every$match, _duration$match;
    const [, interval, frequency] = (_every$match = every === null || every === void 0 ? void 0 : every.match(_constants.INTERVAL_FREQUENCY_REGEXP)) !== null && _every$match !== void 0 ? _every$match : [];
    const [, durationNumber, durationUnit] = (_duration$match = duration.match(_constants.DURATION_REGEX)) !== null && _duration$match !== void 0 ? _duration$match : [];
    const intervalInDays = _moment.default.duration(interval, frequency).asDays();
    const durationInDays = _moment.default.duration(durationNumber, durationUnit).asDays();
    if (intervalInDays && interval && durationInDays >= intervalInDays) {
      return `Recurrence every ${every} must be longer than the duration ${duration}.`;
    }
  }
  if (end && occurrences) {
    return `Only one of 'end' or 'occurrences' can be set for recurring schedules.`;
  }
  return;
};
exports.validateSchedule = validateSchedule;