"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartComponent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _use_common_chart_props = require("./use_common_chart_props");
var _use_aiops_app_context = require("../../hooks/use_aiops_app_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/aiops/public/components/change_point_detection/chart_component.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ChartComponent = exports.ChartComponent = /*#__PURE__*/_react.default.memo(({
  annotation,
  fieldConfig,
  interval,
  onLoading,
  onRenderComplete
}) => {
  const {
    lens: {
      EmbeddableComponent
    }
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const chartWrapperRef = (0, _react.useRef)(null);
  const renderCompleteListener = (0, _react.useCallback)(event => {
    if (event.target === chartWrapperRef.current) return;
    if (onRenderComplete) {
      onRenderComplete();
    }
  }, [onRenderComplete]);
  (0, _react.useEffect)(() => {
    if (!chartWrapperRef.current) {
      throw new Error('Reference to the chart wrapper is not set');
    }
    const chartWrapper = chartWrapperRef.current;
    chartWrapper.addEventListener('renderComplete', renderCompleteListener);
    return () => {
      chartWrapper.removeEventListener('renderComplete', renderCompleteListener);
    };
  }, [renderCompleteListener]);
  const {
    filters,
    timeRange,
    query,
    attributes
  } = (0, _use_common_chart_props.useCommonChartProps)({
    fieldConfig,
    annotation,
    bucketInterval: interval
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    ref: chartWrapperRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(EmbeddableComponent, {
    id: `changePointChart_${annotation.group ? annotation.group.value : annotation.label}`,
    style: {
      height: 350
    },
    timeRange: timeRange,
    query: query,
    filters: filters
    // @ts-ignore
    ,
    attributes: attributes,
    renderMode: 'view',
    executionContext: {
      type: 'aiops_change_point_detection_chart',
      name: 'Change point detection'
    },
    disableTriggers: true,
    onLoad: onLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 9
    }
  }));
});