"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiAccordionStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiAccordionStyles = exports.euiAccordionStyles = function euiAccordionStyles(_ref) {
  var euiTheme = _ref.euiTheme;
  return {
    euiAccordion: /*#__PURE__*/(0, _react.css)(";label:euiAccordion;"),
    // Borders
    borders: {
      // Prevent border repeats
      borders: /*#__PURE__*/(0, _react.css)("&+[class*='euiAccordion-borders']{", (0, _global_styling.logicalCSS)('border-top', 'none'), ";};label:borders;"),
      horizontal: /*#__PURE__*/(0, _react.css)("border-block:", euiTheme.border.thin, ";;label:horizontal;"),
      all: /*#__PURE__*/(0, _react.css)("border:", euiTheme.border.thin, ";;label:all;")
    }
  };
};