"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatasetQualityIndicator = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _translations = require("../../../common/translations");
var _ = require(".");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/dataset_quality/public/components/quality_indicator/dataset_quality_indicator.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DatasetQualityIndicator = ({
  isLoading,
  quality,
  verbose = false,
  dataTestSubj
}) => {
  const QUALITY_LABELS = {
    good: _translations.summaryPanelQualityGoodText,
    degraded: _translations.summaryPanelQualityDegradedText,
    poor: _translations.summaryPanelQualityPoorText
  };
  const translatedQuality = _i18n.i18n.translate('xpack.datasetQuality.datasetQualityIdicator', {
    defaultMessage: '{quality}{verbose, select, true { quality} other {}}',
    values: {
      quality: QUALITY_LABELS[quality],
      verbose
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
    width: "50px",
    height: "20px",
    borderRadius: "m",
    isLoading: isLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_.QualityIndicator, {
    dataTestSubj: dataTestSubj,
    quality: quality,
    description: translatedQuality,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 9
    }
  })));
};
exports.DatasetQualityIndicator = DatasetQualityIndicator;