"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Card = Card;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/dataset_quality/public/components/dataset_quality_details/overview/quality_summary_cards/card.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function Card({
  isDisabled,
  isSelected,
  title,
  titleTooltipContent,
  kpiValue,
  footer,
  onClick,
  isLoading = false,
  dataTestSubjTitle
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const style = (0, _react2.css)`
    height: 100%;
    min-width: 300px;
    border: ${isSelected ? `${euiTheme.border.width.thin} solid ${euiTheme.colors.borderStrongPrimary}` : 'none'};
    background-color: ${isSelected ? euiTheme.colors.backgroundLightPrimary : 'inherit'};
  `;
  const divStyle = (0, _react2.css)`
    ${style}
    padding: ${euiTheme.size.m};
  `;
  const dataTestSubject = `datasetQualityDetailsSummaryKpiCard-${dataTestSubjTitle || title}`;
  const content = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    textAlign: "left",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }, titleTooltipContent ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    wrap: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 13
    }
  }, title), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: titleTooltipContent,
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 15
    }
  }))) : title), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonTitle, {
    size: "m",
    isLoading: isLoading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    textAlign: "left",
    "data-test-subj": `datasetQualityDetailsSummaryKpiValue-${title}`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 11
    }
  }, kpiValue))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 1,
    isLoading: isLoading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    textAlign: "left",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 9
    }
  }, footer)));
  return onClick ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    isDisabled: isDisabled,
    onClick: onClick,
    css: style,
    contentProps: {
      css: (0, _react2.css)`
          justify-content: flex-start;
        `
    },
    "aria-label": title,
    "data-test-subj": dataTestSubject,
    color: isSelected ? 'primary' : 'text',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 5
    }
  }, content) : /*#__PURE__*/_react.default.createElement("div", {
    css: divStyle,
    "data-test-subj": dataTestSubject,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 5
    }
  }, content);
}