"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UiSettingsPublicToCommon = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class UiSettingsPublicToCommon {
  constructor(uiSettings) {
    (0, _defineProperty2.default)(this, "uiSettings", void 0);
    this.uiSettings = uiSettings;
  }
  get(key) {
    return Promise.resolve(this.uiSettings.get(key));
  }
  getAll() {
    return Promise.resolve(this.uiSettings.getAll());
  }
  set(key, value) {
    this.uiSettings.set(key, value);
    return Promise.resolve();
  }
  remove(key) {
    this.uiSettings.remove(key);
    return Promise.resolve();
  }
}
exports.UiSettingsPublicToCommon = UiSettingsPublicToCommon;