"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.flyoutCreateDrilldownAction = exports.OPEN_FLYOUT_ADD_DRILLDOWN = void 0;
var _public = require("@kbn/embeddable-enhanced-plugin/public");
var _public2 = require("@kbn/embeddable-plugin/public");
var _i18n = require("@kbn/i18n");
var _presentationUtil = require("@kbn/presentation-util");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _public3 = require("@kbn/ui-actions-plugin/public");
var _react = _interopRequireDefault(require("react"));
var _drilldown_shared = require("../drilldown_shared");
var _kibana_services = require("../../../kibana_services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/dashboard_enhanced/public/services/drilldowns/actions/flyout_create_drilldown/flyout_create_drilldown.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const OPEN_FLYOUT_ADD_DRILLDOWN = exports.OPEN_FLYOUT_ADD_DRILLDOWN = 'OPEN_FLYOUT_ADD_DRILLDOWN';
const isApiCompatible = api => (0, _public.apiHasDynamicActions)(api) && (0, _presentationPublishing.apiHasParentApi)(api) && (0, _presentationPublishing.apiCanAccessViewMode)(api) && (0, _presentationPublishing.apiHasSupportedTriggers)(api);
const flyoutCreateDrilldownAction = exports.flyoutCreateDrilldownAction = {
  id: OPEN_FLYOUT_ADD_DRILLDOWN,
  type: OPEN_FLYOUT_ADD_DRILLDOWN,
  order: 12,
  getIconType: () => 'plusInCircle',
  grouping: [_drilldown_shared.DRILLDOWN_ACTION_GROUP],
  getDisplayName: () => _i18n.i18n.translate('xpack.dashboard.FlyoutCreateDrilldownAction.displayName', {
    defaultMessage: 'Create drilldown'
  }),
  isCompatible: async ({
    embeddable
  }) => {
    if (!isApiCompatible(embeddable)) return false;
    if ((0, _presentationPublishing.getInheritedViewMode)(embeddable) !== 'edit' || !(0, _presentationPublishing.apiIsOfType)(embeddable.parentApi, 'dashboard')) return false;
    const supportedTriggers = [_public2.CONTEXT_MENU_TRIGGER, ...embeddable.supportedTriggers()];

    /**
     * Check if there is an intersection between all registered drilldowns possible triggers that they could be attached to
     * and triggers that current embeddable supports
     */
    const allPossibleTriggers = _kibana_services.uiActionsEnhancedServices.getActionFactories().map(factory => factory.isCompatibleLicense() ? factory.supportedTriggers() : []).reduce((res, next) => res.concat(next), []);
    return (0, _drilldown_shared.ensureNestedTriggers)(supportedTriggers).some(trigger => allPossibleTriggers.includes(trigger));
  },
  execute: async ({
    embeddable
  }) => {
    if (!isApiCompatible(embeddable)) throw new _public3.IncompatibleActionError();
    (0, _presentationUtil.openLazyFlyout)({
      core: _kibana_services.coreServices,
      parentApi: embeddable.parentApi,
      loadContent: async ({
        closeFlyout
      }) => {
        const templates = (0, _drilldown_shared.createDrilldownTemplatesFromSiblings)(embeddable);
        const triggers = [...(0, _drilldown_shared.ensureNestedTriggers)(embeddable.supportedTriggers()), _public2.CONTEXT_MENU_TRIGGER];
        return /*#__PURE__*/_react.default.createElement(_kibana_services.uiActionsEnhancedServices.DrilldownManager, {
          closeAfterCreate: true,
          initialRoute: '/new',
          dynamicActionManager: embeddable.enhancements.dynamicActions,
          triggers: triggers,
          placeContext: {
            embeddable
          },
          templates: templates,
          onClose: closeFlyout,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 106,
            columnNumber: 11
          }
        });
      },
      flyoutProps: {
        'data-test-subj': 'createDrilldownFlyout',
        'aria-labelledby': 'drilldownFlyoutTitleAriaId',
        focusedPanelId: (0, _presentationPublishing.apiHasUniqueId)(embeddable) ? embeddable.uuid : undefined
      }
    });
  }
};