"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.App = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _notifications = require("./services/notifications");
var _routing = require("./services/routing");
var _api = require("./services/api");
var _shared_imports = require("../shared_imports");
var _sections = require("./sections");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/cross_cluster_replication/public/app/app.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// @ts-ignore
// @ts-ignore
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class AppComponent extends _react.Component {
  constructor(props) {
    super(props);
    this.registerRouter();
    this.state = {
      isFetchingPermissions: false,
      fetchPermissionError: undefined,
      hasPermission: false,
      missingClusterPrivileges: []
    };
  }
  componentDidMount() {
    this.checkPermissions();
  }
  async checkPermissions() {
    this.setState({
      isFetchingPermissions: true
    });
    try {
      const {
        hasPermission,
        missingClusterPrivileges
      } = await (0, _api.loadPermissions)();
      this.setState({
        isFetchingPermissions: false,
        hasPermission,
        missingClusterPrivileges
      });
    } catch (error) {
      // Expect an error in the shape provided by Angular's $http service.
      if (error && error.body) {
        return this.setState({
          isFetchingPermissions: false,
          fetchPermissionError: error
        });
      }

      // This error isn't an HTTP error, so let the fatal error screen tell the user something
      // unexpected happened.
      (0, _notifications.getFatalErrors)().add(error, _i18n.i18n.translate('xpack.crossClusterReplication.app.checkPermissionsFatalErrorTitle', {
        defaultMessage: 'Cross-Cluster Replication app'
      }));
    }
  }
  registerRouter() {
    const {
      history,
      getUrlForApp
    } = this.props;
    _routing.routing.reactRouter = {
      history,
      route: {
        location: history.location
      },
      getUrlForApp
    };
  }
  render() {
    const {
      isFetchingPermissions,
      fetchPermissionError,
      hasPermission,
      missingClusterPrivileges
    } = this.state;
    if (isFetchingPermissions) {
      return /*#__PURE__*/_react.default.createElement(_shared_imports.SectionLoading, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 112,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.crossClusterReplication.app.permissionCheckTitle",
        defaultMessage: "Checking permissions\u2026",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 113,
          columnNumber: 11
        }
      }));
    }
    if (fetchPermissionError) {
      return /*#__PURE__*/_react.default.createElement(_shared_imports.PageError, {
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.crossClusterReplication.app.permissionCheckErrorTitle",
          defaultMessage: "Error checking permissions",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 125,
            columnNumber: 13
          }
        }),
        error: fetchPermissionError,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 123,
          columnNumber: 9
        }
      });
    }
    if (!hasPermission) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
        iconType: "securityApp",
        title: /*#__PURE__*/_react.default.createElement("h2", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 140,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.crossClusterReplication.app.deniedPermissionTitle",
          defaultMessage: "You're missing cluster privileges",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 141,
            columnNumber: 15
          }
        })),
        body: /*#__PURE__*/_react.default.createElement("p", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 148,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.crossClusterReplication.app.deniedPermissionDescription",
          defaultMessage: "To use Cross-Cluster Replication, you must have {clusterPrivilegesCount, plural, one {this cluster privilege} other {these cluster privileges}}: {clusterPrivileges}.",
          values: {
            clusterPrivileges: missingClusterPrivileges.join(', '),
            clusterPrivilegesCount: missingClusterPrivileges.length
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 149,
            columnNumber: 15
          }
        })),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 137,
          columnNumber: 9
        }
      });
    }
    return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
      history: this.props.history,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 165,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 166,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      exact: true,
      from: "/",
      to: "/follower_indices",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 167,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
      exact: true,
      path: "/auto_follow_patterns/add",
      component: _sections.AutoFollowPatternAdd,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 168,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
      exact: true,
      path: "/auto_follow_patterns/edit/:id",
      component: _sections.AutoFollowPatternEdit,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 169,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
      exact: true,
      path: "/follower_indices/add",
      component: _sections.FollowerIndexAdd,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 170,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
      exact: true,
      path: "/follower_indices/edit/:id",
      component: _sections.FollowerIndexEdit,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 171,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
      exact: true,
      path: ['/:section'],
      component: _sections.CrossClusterReplicationHome,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 172,
        columnNumber: 11
      }
    })));
  }
}
const App = exports.App = AppComponent;