"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LicensePrompt = LicensePrompt;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _use_apm_plugin_context = require("../../../context/apm_plugin/use_apm_plugin_context");
var _use_kibana_url = require("../../../hooks/use_kibana_url");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/license_prompt/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function LicensePrompt({
  text
}) {
  var _licenseManagement$lo;
  const {
    plugins: {
      licenseManagement
    }
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const licensePageUrl = (0, _use_kibana_url.useKibanaUrl)('/app/management/stack/license_management');
  const manageLicenseURL = licenseManagement !== null && licenseManagement !== void 0 && licenseManagement.locator ? licenseManagement === null || licenseManagement === void 0 ? void 0 : (_licenseManagement$lo = licenseManagement.locator) === null || _licenseManagement$lo === void 0 ? void 0 : _licenseManagement$lo.useUrl({
    page: 'dashboard'
  }) : licensePageUrl;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    display: "plain",
    paddingSize: "l",
    title: _i18n.i18n.translate('xpack.apm.license.title', {
      defaultMessage: 'Start free 30-day trial'
    }),
    titleElement: "h2",
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "subdued",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 36,
        columnNumber: 20
      }
    }, text),
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "apmLicensePromptStartTrialButton",
      fill: true,
      href: manageLicenseURL,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.apm.license.button', {
      defaultMessage: 'Start trial'
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 5
    }
  });
}