"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobsListStatus = JobsListStatus;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/ml-plugin/common");
var _mlmanage_jobs_link = require("../../../shared/links/machine_learning_links/mlmanage_jobs_link");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/settings/anomaly_detection/jobs_list_status.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function JobsListStatus({
  jobId,
  jobState,
  datafeedState,
  version
}) {
  const jobIsOk = jobState === _common.JOB_STATE.OPENED || jobState === _common.JOB_STATE.OPENING;
  const datafeedIsOk = datafeedState === _common.DATAFEED_STATE.STARTED || datafeedState === _common.DATAFEED_STATE.STARTING;
  const isClosed = jobState === _common.JOB_STATE.CLOSED || jobState === _common.JOB_STATE.CLOSING;
  const isLegacy = version < 3;
  const statuses = [];
  if (jobIsOk && datafeedIsOk) {
    statuses.push(/*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "success",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 7
      }
    }, _i18n.i18n.translate('xpack.apm.settings.anomalyDetection.jobList.okStatusLabel', {
      defaultMessage: 'OK'
    })));
  } else if (!isClosed) {
    statuses.push(/*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.apm.settings.anomalyDetection.jobList.warningStatusLabel', {
        defaultMessage: 'Job might be experiencing problems. Click the Manage Jobs link to learn more.'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_mlmanage_jobs_link.MLManageJobsLink, {
      jobId: jobId,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "warning",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.apm.settings.anomalyDetection.jobList.warningStatusBadgeLabel', {
      defaultMessage: 'Warning'
    })))));
  }
  if (isClosed) {
    statuses.push(/*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 7
      }
    }, _i18n.i18n.translate('xpack.apm.settings.anomalyDetection.jobList.closedStatusLabel', {
      defaultMessage: 'Closed'
    })));
  }
  if (isLegacy) {
    statuses.push(/*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "default",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 7
      }
    }, ' ', _i18n.i18n.translate('xpack.apm.settings.anomalyDetection.jobList.legacyStatusLabel', {
      defaultMessage: 'Legacy'
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 5
    }
  }, statuses.map((status, idx) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: idx,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 9
    }
  }, status)));
}