"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.APMRuleGroupBy = APMRuleGroupBy;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381058608027644/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/alerting/ui_components/apm_rule_group_by.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function APMRuleGroupBy({
  options,
  fields,
  preSelectedOptions,
  onChange,
  errorOptions
}) {
  const handleChange = (0, _react.useCallback)(selectedOptions => {
    const groupByOption = selectedOptions.map(option => option.label);
    onChange([...new Set(preSelectedOptions.concat(groupByOption))]);
  }, [onChange, preSelectedOptions]);
  const getPreSelectedOptions = () => {
    return preSelectedOptions.map(field => ({
      label: field,
      color: 'lightgray',
      disabled: true
    }));
  };
  const getUserSelectedOptions = groupBy => {
    return (groupBy !== null && groupBy !== void 0 ? groupBy : []).filter(group => !preSelectedOptions.includes(group)).map(field => ({
      label: field,
      color: errorOptions !== null && errorOptions !== void 0 && errorOptions.includes(field) ? 'danger' : undefined
    }));
  };
  const selectedOptions = [...getPreSelectedOptions(), ...getUserSelectedOptions(options.groupBy)];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "data-test-subj": "apmRule-groupBy",
    placeholder: _i18n.i18n.translate('xpack.apm.ruleFlyout.groupByLabel', {
      defaultMessage: 'Everything'
    }),
    "aria-label": _i18n.i18n.translate('xpack.apm.ruleFlyout.groupByAriaLabel', {
      defaultMessage: 'Group by'
    }),
    fullWidth: true,
    singleSelection: false,
    selectedOptions: selectedOptions,
    options: fields.map(field => ({
      label: field
    })),
    onChange: handleChange,
    isClearable: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 5
    }
  });
}