"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.cloneBinding = cloneBinding;
const BindingType_1 = require("../models/BindingType");
const cloneConstantValueBinding_1 = require("./cloneConstantValueBinding");
const cloneDynamicValueBinding_1 = require("./cloneDynamicValueBinding");
const cloneFactoryBinding_1 = require("./cloneFactoryBinding");
const cloneInstanceBinding_1 = require("./cloneInstanceBinding");
const cloneProviderBinding_1 = require("./cloneProviderBinding");
const cloneResolvedValueBinding_1 = require("./cloneResolvedValueBinding");
const cloneServiceRedirectionBinding_1 = require("./cloneServiceRedirectionBinding");
/**
 * Creates a deep clone of a binding.
 *
 * @param binding - The binding to clone
 * @returns A clone of the binding
 */
function cloneBinding(binding) {
    // Switch based on binding type to delegate to specific clone functions
    switch (binding.type) {
        case BindingType_1.bindingTypeValues.ConstantValue:
            return (0, cloneConstantValueBinding_1.cloneConstantValueBinding)(binding);
        case BindingType_1.bindingTypeValues.DynamicValue:
            return (0, cloneDynamicValueBinding_1.cloneDynamicValueBinding)(binding);
        case BindingType_1.bindingTypeValues.Factory:
            return (0, cloneFactoryBinding_1.cloneFactoryBinding)(binding);
        case BindingType_1.bindingTypeValues.Instance:
            return (0, cloneInstanceBinding_1.cloneInstanceBinding)(binding);
        case BindingType_1.bindingTypeValues.Provider:
            return (0, cloneProviderBinding_1.cloneProviderBinding)(binding);
        case BindingType_1.bindingTypeValues.ResolvedValue:
            return (0, cloneResolvedValueBinding_1.cloneResolvedValueBinding)(binding);
        case BindingType_1.bindingTypeValues.ServiceRedirection:
            return (0, cloneServiceRedirectionBinding_1.cloneServiceRedirectionBinding)(binding);
    }
}
//# sourceMappingURL=cloneBinding.js.map