/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.logical.local;

import java.util.HashSet;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.esql.core.expression.predicate.Negatable;
import org.elasticsearch.xpack.esql.expression.predicate.logical.Or;
import org.elasticsearch.xpack.esql.expression.predicate.nulls.IsNotNull;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.OptimizerRules;
import org.elasticsearch.xpack.esql.plan.logical.EsRelation;
import org.elasticsearch.xpack.esql.plan.logical.Filter;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.TimeSeriesAggregate;
import org.elasticsearch.xpack.esql.plan.logical.UnresolvedRelation;

public final class IgnoreNullMetrics
extends OptimizerRules.OptimizerRule<TimeSeriesAggregate> {
    @Override
    public LogicalPlan rule(TimeSeriesAggregate agg) {
        HashSet metrics = new HashSet();
        agg.forEachExpression(Attribute.class, attr -> {
            if (attr.isMetric()) {
                metrics.add(attr);
            }
        });
        if (metrics.isEmpty()) {
            return agg;
        }
        Negatable<UnaryScalarFunction> conditional = null;
        for (Attribute metric : metrics) {
            if (conditional == null) {
                conditional = new IsNotNull(agg.source(), (Expression)metric);
                continue;
            }
            conditional = new Or(agg.source(), (Expression)conditional, (Expression)new IsNotNull(agg.source(), (Expression)metric));
        }
        return agg.replaceChild(new Filter(agg.source(), agg.child(), (Expression)conditional));
    }

    private static boolean isMetricsQuery(LogicalPlan logicalPlan) {
        if (logicalPlan instanceof EsRelation) {
            EsRelation r = (EsRelation)logicalPlan;
            return r.indexMode() == IndexMode.TIME_SERIES;
        }
        if (logicalPlan instanceof UnresolvedRelation) {
            UnresolvedRelation r = (UnresolvedRelation)logicalPlan;
            return r.indexMode() == IndexMode.TIME_SERIES;
        }
        return false;
    }
}

