/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.type.DataTypeConverter;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.Foldables;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Cast;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundToDouble;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundToInt;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundToLong;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;

public class RoundTo
extends EsqlScalarFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "RoundTo", RoundTo::new);
    private final Expression field;
    private final List<Expression> points;
    private DataType resultType;
    private static final Map<DataType, Build> SIGNATURES = Map.ofEntries(Map.entry(DataType.DATETIME, RoundToLong.BUILD), Map.entry(DataType.DATE_NANOS, RoundToLong.BUILD), Map.entry(DataType.INTEGER, RoundToInt.BUILD), Map.entry(DataType.LONG, RoundToLong.BUILD), Map.entry(DataType.DOUBLE, RoundToDouble.BUILD));

    @FunctionInfo(returnType={"double", "integer", "long", "date", "date_nanos"}, description="Rounds down to one of a list of fixed points.", examples={@Example(file="math", tag="round_to")}, appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.PREVIEW, version="9.1.0")})
    public RoundTo(Source source, @Param(name="field", type={"double", "integer", "long", "date", "date_nanos"}, description="The numeric value to round. If `null`, the function returns `null`.") Expression field, @Param(name="points", type={"double", "integer", "long", "date", "date_nanos"}, description="Remaining rounding points. Must be constants.") List<Expression> points) {
        super(source, Iterators.toList((Iterator)Iterators.concat((Iterator[])new Iterator[]{Iterators.single((Object)field), points.iterator()})));
        this.field = field;
        this.points = points;
    }

    private RoundTo(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), in.readNamedWriteableCollectionAsList(Expression.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.field);
        out.writeNamedWriteableCollection(this.points);
    }

    public String getWriteableName() {
        return RoundTo.ENTRY.name;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        int index = 1;
        for (Expression f : this.points) {
            Expression.TypeResolution resolution;
            if (f.dataType() == DataType.NULL || !(resolution = TypeResolutions.isFoldable((Expression)f, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.fromIndex((int)index))).unresolved()) continue;
            return resolution;
        }
        DataType dataType = this.dataType();
        if (dataType == null || !SIGNATURES.containsKey(dataType)) {
            return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"all arguments must be numeric, date, or data_nanos", (Object[])new Object[0]));
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    public DataType dataType() {
        if (this.resultType != null) {
            return this.resultType;
        }
        this.resultType = this.field.dataType();
        for (Expression f : this.points) {
            if (this.resultType == DataType.UNSIGNED_LONG || this.resultType == null || f.dataType() == DataType.UNSIGNED_LONG) {
                return null;
            }
            this.resultType = EsqlDataTypeConverter.commonType(this.resultType, f.dataType());
        }
        return this.resultType;
    }

    public boolean foldable() {
        for (Expression c : this.children()) {
            if (c.foldable()) continue;
            return false;
        }
        return true;
    }

    public Nullability nullable() {
        return Nullability.TRUE;
    }

    public final Expression replaceChildren(List<Expression> newChildren) {
        return new RoundTo(this.source(), newChildren.get(0), newChildren.subList(1, newChildren.size()));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, RoundTo::new, (Object)this.field(), this.points());
    }

    public Expression field() {
        return this.field;
    }

    public List<Expression> points() {
        return this.points;
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        DataType dataType = this.dataType();
        Build build = SIGNATURES.get(dataType);
        if (build == null) {
            throw new IllegalStateException("unsupported type");
        }
        EvalOperator.ExpressionEvaluator.Factory field = toEvaluator.apply(this.field());
        field = Cast.cast(this.source(), this.field().dataType(), dataType, field);
        List points = Iterators.toList((Iterator)Iterators.map(this.points().iterator(), p -> Foldables.valueOf(toEvaluator.foldCtx(), p)));
        List<Object> sortedPoints = RoundTo.sortedRoundingPoints(points, dataType);
        return build.build(this.source(), field, sortedPoints);
    }

    public static List<Object> sortedRoundingPoints(List<Object> points, DataType dataType) {
        List<Number> pointsTobeSorted = points.stream().filter(Objects::nonNull).map(p -> (Number)p).toList();
        return switch (dataType) {
            case DataType.INTEGER -> pointsTobeSorted.stream().mapToInt(Number::intValue).sorted().boxed().collect(Collectors.toList());
            case DataType.DOUBLE -> pointsTobeSorted.stream().mapToDouble(Number::doubleValue).sorted().boxed().collect(Collectors.toList());
            case DataType.LONG, DataType.DATETIME, DataType.DATE_NANOS -> pointsTobeSorted.stream().mapToLong(DataTypeConverter::safeToLong).sorted().boxed().collect(Collectors.toList());
            default -> throw new IllegalArgumentException("Unsupported data type: " + String.valueOf(dataType));
        };
    }

    static interface Build {
        public EvalOperator.ExpressionEvaluator.Factory build(Source var1, EvalOperator.ExpressionEvaluator.Factory var2, List<Object> var3);
    }
}

