/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.nativeaccess.jdk;

import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.StructLayout;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.nativeaccess.CloseableByteBuffer;
import org.elasticsearch.nativeaccess.jdk.JdkCloseableByteBuffer;
import org.elasticsearch.nativeaccess.jdk.LinkerHelper;
import org.elasticsearch.nativeaccess.jdk.MemorySegmentUtil;
import org.elasticsearch.nativeaccess.lib.PosixCLibrary;

class JdkPosixCLibrary
implements PosixCLibrary {
    private static final Logger logger;
    private static final StructLayout CAPTURE_ERRNO_LAYOUT;
    static final Linker.Option CAPTURE_ERRNO_OPTION;
    private static final VarHandle errno$vh;
    private static final MethodHandle geteuid$mh;
    private static final MethodHandle strerror$mh;
    private static final MethodHandle getrlimit$mh;
    private static final MethodHandle setrlimit$mh;
    private static final MethodHandle mlockall$mh;
    private static final MethodHandle fcntl$mh;
    private static final MethodHandle ftruncate$mh;
    private static final MethodHandle open$mh;
    private static final MethodHandle openWithMode$mh;
    private static final MethodHandle close$mh;
    private static final MethodHandle fstat$mh;
    private static final MethodHandle socket$mh;
    private static final MethodHandle connect$mh;
    private static final MethodHandle send$mh;
    static final MemorySegment errnoState;

    JdkPosixCLibrary() {
    }

    static MethodHandle downcallHandleWithErrno(String function, FunctionDescriptor functionDescriptor) {
        return LinkerHelper.downcallHandle(function, functionDescriptor, CAPTURE_ERRNO_OPTION);
    }

    @Override
    public int errno() {
        return errno$vh.get(errnoState);
    }

    @Override
    public String strerror(int errno) {
        try {
            MemorySegment str = strerror$mh.invokeExact(errno);
            return MemorySegmentUtil.getString(str.reinterpret(Long.MAX_VALUE), 0L);
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    @Override
    public int geteuid() {
        try {
            return geteuid$mh.invokeExact();
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    @Override
    public PosixCLibrary.RLimit newRLimit() {
        return new JdkRLimit();
    }

    @Override
    public PosixCLibrary.Stat64 newStat64(int sizeof, int stSizeOffset, int stBlocksOffset) {
        return new JdkStat64(sizeof, stSizeOffset, stBlocksOffset);
    }

    @Override
    public PosixCLibrary.FStore newFStore() {
        return new JdkFStore();
    }

    @Override
    public int getrlimit(int resource, PosixCLibrary.RLimit rlimit) {
        assert (rlimit instanceof JdkRLimit);
        JdkRLimit jdkRlimit = (JdkRLimit)rlimit;
        try {
            return getrlimit$mh.invokeExact(errnoState, resource, jdkRlimit.segment);
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    @Override
    public int setrlimit(int resource, PosixCLibrary.RLimit rlimit) {
        assert (rlimit instanceof JdkRLimit);
        JdkRLimit jdkRlimit = (JdkRLimit)rlimit;
        try {
            return setrlimit$mh.invokeExact(errnoState, resource, jdkRlimit.segment);
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    @Override
    public int mlockall(int flags) {
        try {
            return mlockall$mh.invokeExact(errnoState, flags);
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    @Override
    public int fcntl(int fd, int cmd, PosixCLibrary.FStore fst) {
        assert (fst instanceof JdkFStore);
        JdkFStore jdkFst = (JdkFStore)fst;
        try {
            return fcntl$mh.invokeExact(errnoState, fd, cmd, jdkFst.segment);
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    @Override
    public int ftruncate(int fd, long length) {
        try {
            return ftruncate$mh.invokeExact(errnoState, fd, length);
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    @Override
    public int open(String pathname, int flags) {
        Arena arena = Arena.ofConfined();
        try {
            MemorySegment nativePathname = MemorySegmentUtil.allocateString(arena, pathname);
            int n = open$mh.invokeExact(errnoState, nativePathname, flags);
            if (arena != null) {
                arena.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable t) {
                throw new AssertionError((Object)t);
            }
        }
    }

    @Override
    public int open(String pathname, int flags, int mode) {
        Arena arena = Arena.ofConfined();
        try {
            MemorySegment nativePathname = MemorySegmentUtil.allocateString(arena, pathname);
            int n = openWithMode$mh.invokeExact(errnoState, nativePathname, flags, mode);
            if (arena != null) {
                arena.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable t) {
                throw new AssertionError((Object)t);
            }
        }
    }

    @Override
    public int close(int fd) {
        try {
            return close$mh.invokeExact(errnoState, fd);
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    @Override
    public int fstat64(int fd, PosixCLibrary.Stat64 stat64) {
        assert (stat64 instanceof JdkStat64);
        JdkStat64 jdkStat = (JdkStat64)stat64;
        try {
            return fstat$mh.invokeExact(errnoState, fd, jdkStat.segment);
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    @Override
    public int socket(int domain, int type, int protocol) {
        try {
            return socket$mh.invokeExact(errnoState, domain, type, protocol);
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    @Override
    public PosixCLibrary.SockAddr newUnixSockAddr(String path) {
        return new JdkSockAddr(path);
    }

    @Override
    public int connect(int sockfd, PosixCLibrary.SockAddr addr) {
        assert (addr instanceof JdkSockAddr);
        JdkSockAddr jdkAddr = (JdkSockAddr)addr;
        try {
            return connect$mh.invokeExact(errnoState, sockfd, jdkAddr.segment, (int)jdkAddr.segment.byteSize());
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    @Override
    public long send(int sockfd, CloseableByteBuffer buffer, int flags) {
        assert (buffer instanceof JdkCloseableByteBuffer);
        JdkCloseableByteBuffer nativeBuffer = (JdkCloseableByteBuffer)buffer;
        MemorySegment segment = nativeBuffer.segment;
        try {
            logger.info("Sending {} bytes to socket", new Object[]{buffer.buffer().remaining()});
            return send$mh.invokeExact(errnoState, sockfd, segment, buffer.buffer().remaining(), flags);
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    static {
        MethodHandle fstat;
        logger = LogManager.getLogger(JdkPosixCLibrary.class);
        CAPTURE_ERRNO_LAYOUT = Linker.Option.captureStateLayout();
        CAPTURE_ERRNO_OPTION = Linker.Option.captureCallState("errno");
        errno$vh = MemorySegmentUtil.varHandleWithoutOffset(CAPTURE_ERRNO_LAYOUT, MemoryLayout.PathElement.groupElement("errno"));
        geteuid$mh = LinkerHelper.downcallHandle("geteuid", FunctionDescriptor.of(ValueLayout.JAVA_INT, new MemoryLayout[0]), new Linker.Option[0]);
        strerror$mh = LinkerHelper.downcallHandle("strerror", FunctionDescriptor.of(ValueLayout.ADDRESS, ValueLayout.JAVA_INT), new Linker.Option[0]);
        getrlimit$mh = JdkPosixCLibrary.downcallHandleWithErrno("getrlimit", FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.ADDRESS));
        setrlimit$mh = JdkPosixCLibrary.downcallHandleWithErrno("setrlimit", FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.ADDRESS));
        mlockall$mh = JdkPosixCLibrary.downcallHandleWithErrno("mlockall", FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT));
        fcntl$mh = LinkerHelper.downcallHandle("fcntl", FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.ADDRESS), CAPTURE_ERRNO_OPTION, Linker.Option.firstVariadicArg(2));
        ftruncate$mh = JdkPosixCLibrary.downcallHandleWithErrno("ftruncate", FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_LONG));
        open$mh = LinkerHelper.downcallHandle("open", FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_INT), CAPTURE_ERRNO_OPTION, Linker.Option.firstVariadicArg(2));
        openWithMode$mh = LinkerHelper.downcallHandle("open", FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT), CAPTURE_ERRNO_OPTION, Linker.Option.firstVariadicArg(2));
        close$mh = JdkPosixCLibrary.downcallHandleWithErrno("close", FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT));
        try {
            fstat = JdkPosixCLibrary.downcallHandleWithErrno("fstat64", FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.ADDRESS));
        }
        catch (LinkageError e) {
            int version = System.getProperty("os.arch").equals("aarch64") ? 0 : 1;
            fstat = MethodHandles.insertArguments(JdkPosixCLibrary.downcallHandleWithErrno("__fxstat", FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.ADDRESS)), 1, version);
        }
        fstat$mh = fstat;
        socket$mh = JdkPosixCLibrary.downcallHandleWithErrno("socket", FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT));
        connect$mh = JdkPosixCLibrary.downcallHandleWithErrno("connect", FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_INT));
        send$mh = JdkPosixCLibrary.downcallHandleWithErrno("send", FunctionDescriptor.of(ValueLayout.JAVA_LONG, ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_LONG, ValueLayout.JAVA_INT));
        errnoState = Arena.ofAuto().allocate(CAPTURE_ERRNO_LAYOUT);
    }

    static class JdkRLimit
    implements PosixCLibrary.RLimit {
        private static final MemoryLayout layout = MemoryLayout.structLayout(ValueLayout.JAVA_LONG, ValueLayout.JAVA_LONG);
        private static final VarHandle rlim_cur$vh = MemorySegmentUtil.varHandleWithoutOffset(layout, MemoryLayout.PathElement.groupElement(0L));
        private static final VarHandle rlim_max$vh = MemorySegmentUtil.varHandleWithoutOffset(layout, MemoryLayout.PathElement.groupElement(1L));
        private final MemorySegment segment;

        JdkRLimit() {
            Arena arena = Arena.ofAuto();
            this.segment = arena.allocate(layout);
        }

        @Override
        public long rlim_cur() {
            return rlim_cur$vh.get(this.segment);
        }

        @Override
        public long rlim_max() {
            return rlim_max$vh.get(this.segment);
        }

        @Override
        public void rlim_cur(long v) {
            rlim_cur$vh.set(this.segment, v);
        }

        @Override
        public void rlim_max(long v) {
            rlim_max$vh.set(this.segment, v);
        }

        public String toString() {
            return "JdkRLimit[rlim_cur=" + this.rlim_cur() + ", rlim_max=" + this.rlim_max();
        }
    }

    private static class JdkStat64
    implements PosixCLibrary.Stat64 {
        private final MemorySegment segment;
        private final int stSizeOffset;
        private final int stBlocksOffset;

        JdkStat64(int sizeof, int stSizeOffset, int stBlocksOffset) {
            this.segment = Arena.ofAuto().allocate(sizeof, 8L);
            this.stSizeOffset = stSizeOffset;
            this.stBlocksOffset = stBlocksOffset;
        }

        @Override
        public long st_size() {
            return this.segment.get(ValueLayout.JAVA_LONG, (long)this.stSizeOffset);
        }

        @Override
        public long st_blocks() {
            return this.segment.get(ValueLayout.JAVA_LONG, (long)this.stBlocksOffset);
        }
    }

    private static class JdkFStore
    implements PosixCLibrary.FStore {
        private static final MemoryLayout layout = MemoryLayout.structLayout(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.JAVA_LONG, ValueLayout.JAVA_LONG, ValueLayout.JAVA_LONG);
        private static final VarHandle st_flags$vh = MemorySegmentUtil.varHandleWithoutOffset(layout, MemoryLayout.PathElement.groupElement(0L));
        private static final VarHandle st_posmode$vh = MemorySegmentUtil.varHandleWithoutOffset(layout, MemoryLayout.PathElement.groupElement(1L));
        private static final VarHandle st_offset$vh = MemorySegmentUtil.varHandleWithoutOffset(layout, MemoryLayout.PathElement.groupElement(2L));
        private static final VarHandle st_length$vh = MemorySegmentUtil.varHandleWithoutOffset(layout, MemoryLayout.PathElement.groupElement(3L));
        private static final VarHandle st_bytesalloc$vh = MemorySegmentUtil.varHandleWithoutOffset(layout, MemoryLayout.PathElement.groupElement(4L));
        private final MemorySegment segment = Arena.ofAuto().allocate(layout);

        JdkFStore() {
        }

        @Override
        public void set_flags(int flags) {
            st_flags$vh.set(this.segment, flags);
        }

        @Override
        public void set_posmode(int posmode) {
            st_posmode$vh.set(this.segment, posmode);
        }

        @Override
        public void set_offset(long offset) {
            st_offset$vh.set(this.segment, offset);
        }

        @Override
        public void set_length(long length) {
            st_length$vh.set(this.segment, length);
        }

        @Override
        public long bytesalloc() {
            return st_bytesalloc$vh.get(this.segment);
        }
    }

    private static class JdkSockAddr
    implements PosixCLibrary.SockAddr {
        private static final MemoryLayout layout = MemoryLayout.structLayout(ValueLayout.JAVA_SHORT, MemoryLayout.sequenceLayout(108L, ValueLayout.JAVA_BYTE));
        final MemorySegment segment = Arena.ofAuto().allocate(layout);

        JdkSockAddr(String path) {
            this.segment.set(ValueLayout.JAVA_SHORT, 0L, (short)1);
            MemorySegmentUtil.setString(this.segment, 2L, path);
        }
    }
}

