/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.lucene;

import java.util.List;
import java.util.function.Function;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.lucene.DataPartitioning;
import org.elasticsearch.compute.lucene.LuceneSliceQueue;
import org.elasticsearch.compute.lucene.LuceneSourceOperator;
import org.elasticsearch.compute.lucene.ShardContext;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.Limiter;
import org.elasticsearch.compute.operator.SourceOperator;
import org.elasticsearch.core.RefCounted;

public final class TimeSeriesSourceOperator
extends LuceneSourceOperator {
    private static final int MAX_TARGET_PAGE_SIZE = 2048;
    private static final int CHUNK_SIZE = 128;

    public TimeSeriesSourceOperator(List<? extends RefCounted> shardContextCounters, BlockFactory blockFactory, int maxPageSize, LuceneSliceQueue sliceQueue, int limit, Limiter limiter) {
        super(shardContextCounters, blockFactory, maxPageSize, sliceQueue, limit, limiter, false);
    }

    @Override
    protected int numMetadataBlocks() {
        return 2;
    }

    @Override
    protected void buildMetadataBlocks(Block[] blocks, int offset, int currentPagePos) {
        blocks[offset] = this.blockFactory.newConstantIntVector(this.currentSlice.slicePosition(), currentPagePos).asBlock();
        blocks[offset + 1] = this.blockFactory.newConstantLongVector(Long.MAX_VALUE, currentPagePos).asBlock();
    }

    public static int pageSize(long estimateRowSizeInBytes, long maxPageSizeInBytes) {
        long chunkSizeInBytes = 128L * estimateRowSizeInBytes;
        long numChunks = Math.ceilDiv(maxPageSizeInBytes, chunkSizeInBytes);
        long pageSize = Math.clamp(numChunks * 128L, 128, 2048);
        return Math.toIntExact(pageSize);
    }

    public static final class Factory
    extends LuceneSourceOperator.Factory {
        public Factory(List<? extends ShardContext> contexts, Function<ShardContext, List<LuceneSliceQueue.QueryAndTags>> queryFunction, int taskConcurrency, int maxPageSize, int limit) {
            super(contexts, queryFunction, DataPartitioning.SHARD, (int query) -> {
                throw new UnsupportedOperationException("locked to SHARD partitioning");
            }, taskConcurrency, maxPageSize, limit, false);
        }

        @Override
        public SourceOperator get(DriverContext driverContext) {
            return new TimeSeriesSourceOperator(this.contexts, driverContext.blockFactory(), this.maxPageSize, this.sliceQueue, this.limit, this.limiter);
        }

        @Override
        public String describe() {
            return "TimeSeriesSourceOperator[maxPageSize = " + this.maxPageSize + ", limit = " + this.limit + "]";
        }
    }
}

