/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.time.ZoneId;
import java.util.Objects;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.bucket.histogram.DateIntervalConsumer;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class DateIntervalWrapper
implements ToXContentFragment,
Writeable {
    private static final ParseField FIXED_INTERVAL_FIELD = new ParseField("fixed_interval", new String[0]);
    private static final ParseField CALENDAR_INTERVAL_FIELD = new ParseField("calendar_interval", new String[0]);
    private DateHistogramInterval dateHistogramInterval;
    private IntervalTypeEnum intervalType = IntervalTypeEnum.NONE;

    public static <T extends DateIntervalConsumer<T>> void declareIntervalFields(ObjectParser<T, String> parser) {
        parser.declareField(DateIntervalConsumer::calendarInterval, p -> new DateHistogramInterval(p.text()), CALENDAR_INTERVAL_FIELD, ObjectParser.ValueType.STRING);
        parser.declareField(DateIntervalConsumer::fixedInterval, p -> new DateHistogramInterval(p.text()), FIXED_INTERVAL_FIELD, ObjectParser.ValueType.STRING);
    }

    public DateIntervalWrapper() {
    }

    public DateIntervalWrapper(StreamInput in) throws IOException {
        this.dateHistogramInterval = in.readOptionalWriteable(DateHistogramInterval::new);
        this.intervalType = IntervalTypeEnum.fromStream(in);
    }

    public IntervalTypeEnum getIntervalType() {
        return this.intervalType;
    }

    public DateHistogramInterval getAsCalendarInterval() {
        if (this.intervalType.equals(IntervalTypeEnum.CALENDAR)) {
            return this.dateHistogramInterval;
        }
        throw new IllegalStateException("Cannot convert [" + this.intervalType.toString() + "] interval type into calendar interval");
    }

    public void calendarInterval(DateHistogramInterval interval) {
        if (interval == null || Strings.isNullOrEmpty(interval.toString())) {
            throw new IllegalArgumentException("[interval] must not be null: [date_histogram]");
        }
        if (DateHistogramAggregationBuilder.DATE_FIELD_UNITS.get(interval.toString()) == null) {
            throw new IllegalArgumentException("The supplied interval [" + String.valueOf(interval) + "] could not be parsed as a calendar interval.");
        }
        this.setIntervalType(IntervalTypeEnum.CALENDAR);
        this.dateHistogramInterval = interval;
    }

    public DateHistogramInterval getAsFixedInterval() {
        if (this.intervalType.equals(IntervalTypeEnum.FIXED) || this.tryIntervalAsFixedUnit() != null) {
            return this.dateHistogramInterval;
        }
        throw new IllegalStateException("Cannot convert [" + this.intervalType.toString() + "] interval type into fixed interval");
    }

    public void fixedInterval(DateHistogramInterval interval) {
        if (interval == null || Strings.isNullOrEmpty(interval.toString())) {
            throw new IllegalArgumentException("[interval] must not be null: [date_histogram]");
        }
        this.setIntervalType(IntervalTypeEnum.FIXED);
        TimeValue.parseTimeValue((String)interval.toString(), (String)"date_histogram.fixedInterval");
        this.dateHistogramInterval = interval;
    }

    Rounding.DateTimeUnit tryIntervalAsCalendarUnit() {
        if (this.intervalType.equals(IntervalTypeEnum.CALENDAR)) {
            return DateHistogramAggregationBuilder.DATE_FIELD_UNITS.get(this.dateHistogramInterval.toString());
        }
        return null;
    }

    TimeValue tryIntervalAsFixedUnit() {
        if (this.dateHistogramInterval == null || Strings.isNullOrEmpty(this.dateHistogramInterval.toString())) {
            return null;
        }
        try {
            return TimeValue.parseTimeValue((String)this.dateHistogramInterval.toString(), null, (String)(this.getClass().getSimpleName() + ".interval"));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public Rounding createRounding(ZoneId timeZone, long offset) {
        Rounding.Builder tzRoundingBuilder;
        if (this.isEmpty()) {
            throw new IllegalArgumentException("Invalid interval specified, must be non-null and non-empty");
        }
        IntervalTypeEnum intervalType = this.getIntervalType();
        if (intervalType.equals(IntervalTypeEnum.FIXED)) {
            tzRoundingBuilder = Rounding.builder(this.tryIntervalAsFixedUnit());
        } else if (intervalType.equals(IntervalTypeEnum.CALENDAR)) {
            tzRoundingBuilder = Rounding.builder(this.tryIntervalAsCalendarUnit());
        } else {
            throw new IllegalArgumentException("Unable to parse interval [" + String.valueOf(this.dateHistogramInterval) + "]");
        }
        if (timeZone != null) {
            tzRoundingBuilder.timeZone(timeZone);
        }
        tzRoundingBuilder.offset(offset);
        return tzRoundingBuilder.build();
    }

    private void setIntervalType(IntervalTypeEnum type) {
        if (this.intervalType.equals(IntervalTypeEnum.NONE) || type.equals(this.intervalType)) {
            this.intervalType = type;
            return;
        }
        if (!type.isValid() || !this.intervalType.isValid()) {
            throw new IllegalArgumentException("Unknown interval type.");
        }
        throw new IllegalArgumentException("Cannot use [" + type.getPreferredName() + "] with [" + this.intervalType.getPreferredName() + "] configuration option.");
    }

    public boolean isEmpty() {
        if (this.intervalType.equals(IntervalTypeEnum.NONE)) {
            return true;
        }
        return this.dateHistogramInterval == null || Strings.isNullOrEmpty(this.dateHistogramInterval.toString());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable(this.dateHistogramInterval);
        this.intervalType.writeTo(out);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.intervalType.equals(IntervalTypeEnum.FIXED)) {
            builder.field(FIXED_INTERVAL_FIELD.getPreferredName(), this.dateHistogramInterval.toString());
        } else if (this.intervalType.equals(IntervalTypeEnum.CALENDAR)) {
            builder.field(CALENDAR_INTERVAL_FIELD.getPreferredName(), this.dateHistogramInterval.toString());
        }
        return builder;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DateIntervalWrapper that = (DateIntervalWrapper)other;
        if (this.tryIntervalAsCalendarUnit() != null && that.tryIntervalAsCalendarUnit() == null) {
            return false;
        }
        if (this.tryIntervalAsCalendarUnit() == null && that.tryIntervalAsCalendarUnit() != null) {
            return false;
        }
        return Objects.equals(this.dateHistogramInterval, that.dateHistogramInterval);
    }

    public int hashCode() {
        boolean isCalendar = this.tryIntervalAsCalendarUnit() != null;
        return Objects.hash(this.dateHistogramInterval, isCalendar);
    }

    public static enum IntervalTypeEnum implements Writeable
    {
        NONE("none"),
        FIXED(FIXED_INTERVAL_FIELD.getPreferredName()),
        CALENDAR(CALENDAR_INTERVAL_FIELD.getPreferredName()),
        LEGACY_INTERVAL(null),
        LEGACY_DATE_HISTO(null);

        private final String preferredName;

        public static IntervalTypeEnum fromStream(StreamInput in) throws IOException {
            return in.readEnum(IntervalTypeEnum.class);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeEnum(this);
        }

        public boolean isValid() {
            return this.preferredName != null;
        }

        public String getPreferredName() {
            if (this.preferredName == null) {
                throw new IllegalStateException("Invalid use of legacy date histogram interval");
            }
            return this.preferredName;
        }

        private IntervalTypeEnum(String preferredName) {
            this.preferredName = preferredName;
        }
    }
}

