/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class StoreStats
implements Writeable,
ToXContentFragment {
    public static final long UNKNOWN_RESERVED_BYTES = -1L;
    private long sizeInBytes;
    private long totalDataSetSizeInBytes;
    private long reservedSizeInBytes;

    public StoreStats() {
    }

    public StoreStats(StreamInput in) throws IOException {
        this.sizeInBytes = in.readVLong();
        this.totalDataSetSizeInBytes = in.readVLong();
        this.reservedSizeInBytes = in.readZLong();
    }

    public StoreStats(long sizeInBytes, long totalDataSetSizeInBytes, long reservedSize) {
        assert (reservedSize == -1L || reservedSize >= 0L) : reservedSize;
        this.sizeInBytes = sizeInBytes;
        this.totalDataSetSizeInBytes = totalDataSetSizeInBytes;
        this.reservedSizeInBytes = reservedSize;
    }

    public void add(StoreStats stats) {
        if (stats == null) {
            return;
        }
        this.sizeInBytes += stats.sizeInBytes;
        this.totalDataSetSizeInBytes += stats.totalDataSetSizeInBytes;
        this.reservedSizeInBytes = StoreStats.ignoreIfUnknown(this.reservedSizeInBytes) + StoreStats.ignoreIfUnknown(stats.reservedSizeInBytes);
    }

    private static long ignoreIfUnknown(long reservedSize) {
        return reservedSize == -1L ? 0L : reservedSize;
    }

    public long sizeInBytes() {
        return this.sizeInBytes;
    }

    public ByteSizeValue size() {
        return ByteSizeValue.ofBytes(this.sizeInBytes);
    }

    public long totalDataSetSizeInBytes() {
        return this.totalDataSetSizeInBytes;
    }

    public ByteSizeValue totalDataSetSize() {
        return ByteSizeValue.ofBytes(this.totalDataSetSizeInBytes);
    }

    public long reservedSizeInBytes() {
        return this.reservedSizeInBytes;
    }

    public ByteSizeValue getReservedSize() {
        return ByteSizeValue.ofBytes(this.reservedSizeInBytes);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.sizeInBytes);
        out.writeVLong(this.totalDataSetSizeInBytes);
        out.writeZLong(this.reservedSizeInBytes);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("store");
        builder.humanReadableField("size_in_bytes", "size", (Object)this.size());
        builder.humanReadableField("total_data_set_size_in_bytes", "total_data_set_size", (Object)this.totalDataSetSize());
        builder.humanReadableField("reserved_in_bytes", "reserved", (Object)this.getReservedSize());
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoreStats that = (StoreStats)o;
        return this.sizeInBytes == that.sizeInBytes && this.totalDataSetSizeInBytes == that.totalDataSetSizeInBytes && this.reservedSizeInBytes == that.reservedSizeInBytes;
    }

    public int hashCode() {
        return Objects.hash(this.sizeInBytes, this.totalDataSetSizeInBytes, this.reservedSizeInBytes);
    }

    static final class Fields {
        static final String STORE = "store";
        static final String SIZE = "size";
        static final String SIZE_IN_BYTES = "size_in_bytes";
        static final String TOTAL_DATA_SET_SIZE = "total_data_set_size";
        static final String TOTAL_DATA_SET_SIZE_IN_BYTES = "total_data_set_size_in_bytes";
        static final String RESERVED = "reserved";
        static final String RESERVED_IN_BYTES = "reserved_in_bytes";

        Fields() {
        }
    }
}

